@extends('layouts.app')

@section('title', 'Detail Instrumen Penilaian')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-eye"></i> Detail Instrumen Penilaian
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('kepala.instrumen.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="{{ route('kepala.instrumen.isi', $distribusi->id) }}" class="btn btn-success">
                            <i class="fas fa-edit"></i> Isi Instrumen
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- Instrumen Information -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-info-circle"></i> Informasi Instrumen
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-3">Judul Instrumen:</dt>
                                        <dd class="col-sm-9">
                                            <strong>{{ $distribusi->instrumen->judul }}</strong>
                                        </dd>

                                        <dt class="col-sm-3">Tahun Ajaran:</dt>
                                        <dd class="col-sm-9">{{ $distribusi->instrumen->tahun_ajaran }} - Semester {{ $distribusi->instrumen->semester }}</dd>

                                        @if($distribusi->instrumen->deskripsi)
                                        <dt class="col-sm-3">Deskripsi:</dt>
                                        <dd class="col-sm-9">{{ $distribusi->instrumen->deskripsi }}</dd>
                                        @endif

                                        <dt class="col-sm-3">Tanggal Distribusi:</dt>
                                        <dd class="col-sm-9">{{ $distribusi->tanggal_distribusi->format('d F Y') }}</dd>

                                        <dt class="col-sm-3">Deadline:</dt>
                                        <dd class="col-sm-9">
                                            {{ $distribusi->deadline->format('d F Y') }}
                                            @if($distribusi->deadline->isPast() && $distribusi->status == 'active')
                                                <span class="badge badge-danger ml-2">Terlambat</span>
                                            @elseif($distribusi->deadline->diffInDays() <= 7 && $distribusi->status == 'active')
                                                <span class="badge badge-warning ml-2">Mendekati Deadline</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Komponen:</dt>
                                        <dd class="col-sm-9">
                                            @if($distribusi->komponen)
                                                <span class="badge badge-info">
                                                    <i class="fas fa-puzzle-piece"></i> {{ $distribusi->komponen->nama_komponen }}
                                                </span>
                                                @if($distribusi->komponen->deskripsi)
                                                    <br><small class="text-muted">{{ $distribusi->komponen->deskripsi }}</small>
                                                @endif
                                            @else
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Semua Komponen
                                                </span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Status:</dt>
                                        <dd class="col-sm-9">
                                            @if($distribusi->status == 'active')
                                                <span class="badge badge-success">Aktif</span>
                                            @else
                                                <span class="badge badge-secondary">Ditutup</span>
                                            @endif
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-chart-pie"></i> Statistik Penilaian
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="border-right">
                                                <h3 class="text-primary">{{ $penilaianStats['total_kepala'] }}</h3>
                                                <small class="text-muted">Total Penilaian</small>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <h3 class="text-warning">{{ $penilaianStats['submitted'] }}</h3>
                                            <small class="text-muted">Menunggu Review</small>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-clock text-secondary"></i> Draft: {{ $penilaianStats['draft'] }}
                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-paper-plane text-warning"></i> Submitted: {{ $penilaianStats['submitted'] }}
                                            </small>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-edit text-warning"></i> Revision: {{ $penilaianStats['revision'] }}
                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-check-circle text-success"></i> Validated: {{ $penilaianStats['validated'] }}
                                            </small>
                                        </div>
                                    </div>
                                    
                                    @if($penilaianStats['total_kepala'] > 0)
                                    @php
                                        $percentage = round(($penilaianStats['validated'] / $penilaianStats['total_kepala']) * 100, 1);
                                    @endphp
                                    <div class="mt-3">
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $percentage }}%" aria-valuenow="{{ $percentage }}" aria-valuemin="0" aria-valuemax="100">
                                                {{ $percentage }}%
                                            </div>
                                        </div>
                                        <small class="text-muted">Progress Penyelesaian</small>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Struktur Instrumen Hierarkis -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-list-alt"></i> Struktur Instrumen Penilaian
                            </h4>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            @if($distribusi->komponen)
                                <!-- Per Komponen Distribution -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th width="8%">No</th>
                                                <th width="35%">Indikator Kerja</th>
                                                <th width="30%">Evidensi Kerja</th>
                                                <th width="8%">Skor Min</th>
                                                <th width="8%">Skor Max</th>
                                                <th width="11%">Jenis</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                                            @endphp
                                            
                                            <!-- Komponen Row (Level Tertinggi) -->
                                            <tr class="table-dark">
                                                <td><strong>1</strong></td>
                                                <td>
                                                    <strong>{{ $distribusi->komponen->nama_komponen }}</strong>
                                                    @if($distribusi->komponen->deskripsi)
                                                        <br><small class="text-muted">{{ $distribusi->komponen->deskripsi }}</small>
                                                    @endif
                                                </td>
                                                <td colspan="3">
                                                    <span class="badge badge-dark">Komponen</span>
                                                    <span class="badge badge-secondary">{{ $distribusi->komponen->subKomponens->count() }} Sub Komponen</span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-dark">Komponen</span>
                                                </td>
                                            </tr>
                                            
                                            @foreach($distribusi->komponen->subKomponens as $subKomponenIndex => $subKomponen)
                                                <!-- Sub Komponen Row (A, B, C, dst.) -->
                                                <tr class="table-primary">
                                                    <td><strong>{{ $komponenLetters[$subKomponenIndex] }}</strong></td>
                                                    <td>
                                                        <strong>{{ $subKomponen->nama_sub_komponen }}</strong>
                                                        @if($subKomponen->deskripsi)
                                                            <br><small class="text-muted">{{ $subKomponen->deskripsi }}</small>
                                                        @endif
                                                    </td>
                                                    <td colspan="3">
                                                        <span class="badge badge-info">Sub Komponen</span>
                                                        <span class="badge badge-light">{{ $subKomponen->instrumenPenilaians->count() }} Instrumen</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-primary">Sub Komponen</span>
                                                    </td>
                                                </tr>
                                                
                                                @foreach($subKomponen->instrumenPenilaians as $item)
                                                    <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                                    <tr class="table-light">
                                                        <td>
                                                            <strong>{{ $komponenLetters[$subKomponenIndex] }}{{ $item->no_urutan }}</strong>
                                                        </td>
                                                        <td>
                                                            <div class="text-sm">
                                                                <strong>{{ $item->indikator_kinerja }}</strong>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-sm">
                                                                {{ $item->evidensi_kinerja ?: '-' }}
                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="badge badge-success">{{ $item->skor_min }}</span>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="badge badge-danger">{{ $item->skor_max }}</span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-light">Instrumen</span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <!-- Semua Komponen Distribution -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th width="8%">No</th>
                                                <th width="35%">Indikator Kerja</th>
                                                <th width="30%">Evidensi Kerja</th>
                                                <th width="8%">Skor Min</th>
                                                <th width="8%">Skor Max</th>
                                                <th width="11%">Jenis</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                                            @endphp
                                            
                                            @foreach($distribusi->instrumen->komponenPenilaians as $komponenIndex => $komponen)
                                                <!-- Komponen Row (Level Tertinggi) -->
                                                <tr class="table-dark">
                                                    <td><strong>{{ $komponenIndex + 1 }}</strong></td>
                                                    <td>
                                                        <strong>{{ $komponen->nama_komponen }}</strong>
                                                        @if($komponen->deskripsi)
                                                            <br><small class="text-muted">{{ $komponen->deskripsi }}</small>
                                                        @endif
                                                    </td>
                                                    <td colspan="3">
                                                        <span class="badge badge-dark">Komponen</span>
                                                        <span class="badge badge-secondary">{{ $komponen->subKomponens->count() }} Sub Komponen</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-dark">Komponen</span>
                                                    </td>
                                                </tr>
                                                
                                                @foreach($komponen->subKomponens as $subKomponenIndex => $subKomponen)
                                                    <!-- Sub Komponen Row (A, B, C, dst.) -->
                                                    <tr class="table-primary">
                                                        <td><strong>{{ $komponenLetters[$subKomponenIndex] }}</strong></td>
                                                        <td>
                                                            <strong>{{ $subKomponen->nama_sub_komponen }}</strong>
                                                            @if($subKomponen->deskripsi)
                                                                <br><small class="text-muted">{{ $subKomponen->deskripsi }}</small>
                                                            @endif
                                                        </td>
                                                        <td colspan="3">
                                                            <span class="badge badge-info">Sub Komponen</span>
                                                            <span class="badge badge-light">{{ $subKomponen->instrumenPenilaians->count() }} Instrumen</span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-primary">Sub Komponen</span>
                                                        </td>
                                                    </tr>
                                                    
                                                    @foreach($subKomponen->instrumenPenilaians as $item)
                                                        <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                                        <tr class="table-light">
                                                            <td>
                                                                <strong>{{ $komponenLetters[$subKomponenIndex] }}{{ $item->no_urutan }}</strong>
                                                            </td>
                                                            <td>
                                                                <div class="text-sm">
                                                                    <strong>{{ $item->indikator_kinerja }}</strong>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-sm">
                                                                    {{ $item->evidensi_kinerja ?: '-' }}
                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="badge badge-success">{{ $item->skor_min }}</span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="badge badge-danger">{{ $item->skor_max }}</span>
                                                            </td>
                                                            <td>
                                                                <span class="badge badge-light">Instrumen</span>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Penilaian Kepala (oleh Pengawas) -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-users"></i> Status Penilaian Kepala
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th>Pengawas Penilai</th>
                                            <th>Status</th>
                                            <th>Tanggal Submit</th>
                                            <th>Nilai</th>
                                            <th width="15%">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($penilaianGuru as $penilaian)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>
                                                <strong>{{ $penilaian->pengawas?->name ?? '-' }}</strong>
                                            </td>
                                            <td>
                                                @switch($penilaian->status)
                                                    @case('draft')
                                                        <span class="badge badge-secondary">
                                                            <i class="fas fa-clock"></i> Draft
                                                        </span>
                                                        <br><small class="text-muted">Belum dikirim</small>
                                                        @break
                                                    @case('submitted')
                                                        <span class="badge badge-warning">
                                                            <i class="fas fa-paper-plane"></i> Menunggu Review
                                                        </span>
                                                        <br><small class="text-muted">Siap untuk direview</small>
                                                        @break
                                                    @case('revision')
                                                        <span class="badge badge-info">
                                                            <i class="fas fa-edit"></i> Perlu Revisi
                                                        </span>
                                                        <br><small class="text-muted">Perlu perbaikan</small>
                                                        @break
                                                    @case('validated')
                                                        <span class="badge badge-success">
                                                            <i class="fas fa-check-circle"></i> Validated
                                                        </span>
                                                        <br><small class="text-muted">Sudah disetujui</small>
                                                        @break
                                                @endswitch
                                            </td>
                                            <td>
                                                @if($penilaian->tanggal_submit)
                                                    {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($penilaian->rata_rata)
                                                    <strong class="text-success">{{ number_format($penilaian->rata_rata, 2) }}</strong>
                                                    <br><small class="text-muted">Total: {{ $penilaian->total_nilai }}</small>
                                                @else
                                                    <span class="text-muted">Belum dinilai</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="text-muted">-</span>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="8" class="text-center">
                                                <div class="py-4">
                                                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                                    <h5 class="text-muted">Belum ada data penilaian</h5>
                                                    <p class="text-muted">Pengawas belum menilai.</p>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('kepala.instrumen.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                        </a>
                        
                        <div>
                            @if($penilaianStats['submitted'] > 0)
                                <a href="{{ route('kepala.penilaian.review') }}" class="btn btn-primary">
                                    <i class="fas fa-edit"></i> Review Semua Penilaian ({{ $penilaianStats['submitted'] }})
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush
