@extends('layouts.app')

@section('title', 'Isi Instrumen - Kepala')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><i class="fas fa-edit"></i> Isi Instrumen Penilaian</h3>
                    <a href="{{ route('kepala.instrumen.show', $distribusi->id) }}" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Kembali</a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="mb-3 d-flex justify-content-between align-items-center">
                        <div>
                            <strong>Instrumen:</strong> {{ $distribusi->instrumen->judul }}<br>
                            <small class="text-muted">Tahun {{ $distribusi->instrumen->tahun_ajaran }} - Semester {{ $distribusi->instrumen->semester }}</small>
                        </div>
                        <div>
                            <span class="badge badge-{{ $penilaian->status == 'draft' ? 'secondary' : ($penilaian->status == 'submitted' ? 'warning' : 'success') }}">
                                Status: {{ ucfirst($penilaian->status) }}
                            </span>
                        </div>
                    </div>
                    @if($penilaian->status != 'draft')
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Penilaian telah {{ $penilaian->status }}. Isian dikunci dan tidak dapat diubah.
                            @if(in_array($penilaian->status, ['submitted', 'revision']))
                                <form method="POST" action="{{ route('kepala.instrumen.ubah-status', $distribusi->id) }}" class="d-inline mt-2">
                                    @csrf
                                    <input type="hidden" name="status" value="draft">
                                    <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Apakah Anda yakin ingin mengubah status kembali ke draft? Status akan diubah dan Anda dapat mengedit isian instrumen lagi.')">
                                        <i class="fas fa-undo"></i> Ubah Status ke Draft (Buka Edit)
                                    </button>
                                </form>
                            @endif
                        </div>
                    @endif

                    <form method="POST" action="{{ route('kepala.instrumen.isi.simpan', $distribusi->id) }}">
                        @csrf
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="6%">No</th>
                                        <th>Indikator</th>
                                        <th width="12%">Nilai Diri</th>
                                        <th width="24%">Bukti (URL)</th>
                                        <th width="24%">Keterangan Bukti</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $idx => $item)
                                        @php
                                            $jawaban = $jawabanMap[$item->id] ?? null;
                                        @endphp
                                        <tr>
                                            <td class="text-center">{{ ($items->currentPage() - 1) * $items->perPage() + $idx + 1 }}</td>
                                            <td>
                                                <div class="font-weight-bold">{{ $item->indikator_kinerja }}</div>
                                                @if($item->evidensi_kinerja)
                                                    <small class="text-muted">{{ $item->evidensi_kinerja }}</small>
                                                @endif
                                            </td>
                                            <td>
                                                <input type="number" name="jawaban[{{ $item->id }}][nilai_guru_self]" class="form-control" min="{{ $item->skor_min }}" max="{{ $item->skor_max }}" value="{{ old('jawaban.'.$item->id.'.nilai_guru_self', $jawaban->nilai_guru_self ?? '') }}" {{ $penilaian->status != 'draft' ? 'disabled' : '' }}>
                                            </td>
                                            <td>
                                                <input type="url" name="jawaban[{{ $item->id }}][url_bukti]" class="form-control" placeholder="https://" value="{{ old('jawaban.'.$item->id.'.url_bukti', $jawaban->url_bukti ?? '') }}" {{ $penilaian->status != 'draft' ? 'disabled' : '' }}>
                                            </td>
                                            <td>
                                                <textarea name="jawaban[{{ $item->id }}][keterangan_bukti]" class="form-control" rows="2" placeholder="Keterangan atau catatan" {{ $penilaian->status != 'draft' ? 'disabled' : '' }}>{{ old('jawaban.'.$item->id.'.keterangan_bukti', $jawaban->keterangan_bukti ?? '') }}</textarea>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                {{ $items->links('pagination::bootstrap-4') }}
                            </div>
                            @if($penilaian->status == 'draft')
                                <div class="btn-group">
                                    <button type="submit" name="submit_status" value="save" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
                                    <button type="submit" id="btnSubmit" name="submit_status" value="submitted" class="btn btn-success"><i class="fas fa-paper-plane"></i> Simpan & Submit</button>
                                </div>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const btnSubmit = document.getElementById('btnSubmit');
    if (btnSubmit) {
        btnSubmit.addEventListener('click', function(e) {
            if(!confirm('Apakah semua jawaban Anda sudah valid? Setelah Submit, isian akan dikunci dan tidak dapat diubah kecuali dikembalikan untuk revisi.')) {
                e.preventDefault();
            }
        });
    }
});
</script>
@endpush

