@extends('layouts.app')

@section('title', 'Instrumen Penilaian')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title mb-0">
                        <i class="fas fa-clipboard-list"></i> Instrumen Penilaian Kepala
                    </h3>
                        <div class="d-flex align-items-center">
                            <!-- Notification Dropdown -->
                            <div class="dropdown mr-3">
                                <button class="btn btn-outline-primary btn-sm dropdown-toggle position-relative" type="button" id="notificationDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-bell"></i>
                                    @if($unreadCount > 0)
                                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                            {{ $unreadCount }}
                                            <span class="visually-hidden">unread notifications</span>
                                        </span>
                                    @endif
                                </button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="notificationDropdown" style="width: 380px; max-height: 400px;">
                                    <div class="dropdown-header d-flex justify-content-between align-items-center bg-light">
                                        <h6 class="mb-0">
                                            <i class="fas fa-bell text-primary"></i> Notifikasi
                                        </h6>
                                        @if($unreadCount > 0)
                                            <button class="btn btn-sm btn-outline-primary" onclick="markAllAsRead()">
                                                <i class="fas fa-check-double"></i> Tandai Semua
                                            </button>
                                        @endif
                                    </div>
                                    <div class="dropdown-divider"></div>
                                    <div id="notification-list" style="max-height: 320px; overflow-y: auto;">
                                        @forelse($notifications as $notification)
                                            <div class="dropdown-item notification-item {{ $notification->is_read ? '' : 'bg-light border-start border-primary border-3' }}" 
                                                 data-notification-id="{{ $notification->id }}"
                                                 onclick="markAsRead({{ $notification->id }})"
                                                 style="cursor: pointer; transition: all 0.2s;">
                                                <div class="d-flex align-items-start">
                                                    <div class="flex-grow-1">
                                                        <div class="d-flex justify-content-between align-items-start">
                                                            <div class="font-weight-bold text-dark">{{ $notification->title }}</div>
                                                            @if(!$notification->is_read)
                                                                <span class="badge badge-primary badge-sm">Baru</span>
                                                            @endif
                                                        </div>
                                                        <div class="text-muted small mt-1">{{ $notification->message }}</div>
                                                        <div class="text-muted small mt-1">
                                                            <i class="fas fa-clock"></i> {{ $notification->created_at->diffForHumans() }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @if(!$loop->last)
                                                <div class="dropdown-divider"></div>
                                            @endif
                                        @empty
                                            <div class="dropdown-item text-center text-muted py-4">
                                                <i class="fas fa-bell-slash fa-2x mb-2"></i>
                                                <div>Tidak ada notifikasi</div>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            </div>
                            
                            <a href="{{ route('kepala.dashboard') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
                        </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_instrumen'] }}</h3>
                                    <p>Total Instrumen</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['active_instrumen'] }}</h3>
                                    <p>Instrumen Aktif</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-play-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['pending_review'] }}</h3>
                                    <p>Menunggu Review</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $stats['completed_penilaian'] }}</h3>
                                    <p>Selesai Divalidasi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Instrumen Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Instrumen</th>
                                    <th>Tanggal Distribusi</th>
                                    <th>Deadline</th>
                                    <th>Status</th>
                                    <th>Progress Penilaian</th>
                                    <th>Menunggu Review</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($distribusi as $item)
                                <tr>
                                    <td>{{ $loop->iteration + ($distribusi->currentPage() - 1) * $distribusi->perPage() }}</td>
                                    <td>
                                        <strong>{{ $item->instrumen->judul }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $item->instrumen->tahun_ajaran }} - Semester {{ $item->instrumen->semester }}</small>
                                        @if($item->instrumen->deskripsi)
                                            <br>
                                            <small class="text-muted">{{ Str::limit($item->instrumen->deskripsi, 50) }}</small>
                                        @endif
                                        @if($item->komponen)
                                            <br><span class="badge badge-info">
                                                <i class="fas fa-puzzle-piece"></i> {{ $item->komponen->nama_komponen }}
                                            </span>
                                        @else
                                            <br><span class="badge badge-success">
                                                <i class="fas fa-check-circle"></i> Semua Komponen
                                            </span>
                                        @endif
                                    </td>
                                    <td>{{ $item->tanggal_distribusi->format('d/m/Y') }}</td>
                                    <td>
                                        {{ $item->deadline->format('d/m/Y') }}
                                        @if($item->deadline->isPast() && $item->status == 'active')
                                            <br><small class="text-danger"><i class="fas fa-exclamation-triangle"></i> Terlambat</small>
                                        @elseif($item->deadline->diffInDays() <= 7 && $item->status == 'active')
                                            <br><small class="text-warning"><i class="fas fa-clock"></i> Mendekati Deadline</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->status == 'active')
                                            <span class="badge badge-success">Aktif</span>
                                        @else
                                            <span class="badge badge-secondary">Ditutup</span>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $total = optional($item->penilaianKepala)->count() ?? $item->penilaianKepala()->count();
                                            $completed = $item->penilaianKepala()->whereIn('status', ['validated', 'final'])->count();
                                            $percentage = $total > 0 ? round(($completed / $total) * 100, 1) : 0;
                                        @endphp
                                        
                                        <div class="progress mb-1" style="height: 20px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $percentage }}%" aria-valuenow="{{ $percentage }}" aria-valuemin="0" aria-valuemax="100">
                                                {{ $percentage }}%
                                            </div>
                                        </div>
                                        <small class="text-muted">{{ $completed }}/{{ $total }} kepala</small>
                                    </td>
                                    <td>
                                        @php
                                            $pendingReview = $item->penilaianKepala()->where('status', 'submitted')->count();
                                        @endphp
                                        @if($pendingReview > 0)
                                            <span class="badge badge-warning">
                                                <i class="fas fa-clock"></i> {{ $pendingReview }} penilaian
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('kepala.instrumen.show', $item->id) }}" class="btn btn-primary btn-sm" title="Lihat Detail">
                                            <i class="fas fa-eye"></i> Lihat
                                        </a>
                                        <a href="{{ route('kepala.instrumen.isi', $item->id) }}" class="btn btn-success btn-sm" title="Isi Instrumen">
                                            <i class="fas fa-edit"></i> Isi
                                        </a>
                                        
                                        @if($pendingReview > 0)
                                            <a href="{{ route('kepala.instrumen.show', $item->id) }}" class="btn btn-warning btn-sm" title="Review Penilaian">
                                                <i class="fas fa-edit"></i> Review
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada instrumen yang didistribusikan</h5>
                                            <p class="text-muted">Pengawas belum mendistribusikan instrumen penilaian ke lembaga Anda.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($distribusi->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $distribusi->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
    
    // Auto-refresh notifications every 30 seconds
    setInterval(function() {
        refreshNotifications();
    }, 30000);
});

// Mark notification as read
function markAsRead(notificationId) {
    $.ajax({
        url: '{{ route("kepala.notifications.mark-read", ":id") }}'.replace(':id', notificationId),
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                // Remove the "Baru" badge and update styling
                $('.notification-item[data-notification-id="' + notificationId + '"]')
                    .removeClass('bg-light border-start border-primary border-3')
                    .find('.badge').remove();
                
                // Update unread count
                refreshNotifications();
            }
        },
        error: function(xhr) {
            console.error('Error marking notification as read:', xhr);
        }
    });
}

// Mark all notifications as read
function markAllAsRead() {
    $.ajax({
        url: '{{ route("kepala.notifications.mark-all-read") }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                // Remove all "Baru" badges and update styling
                $('.notification-item').removeClass('bg-light border-start border-primary border-3').find('.badge').remove();
                
                // Update unread count
                refreshNotifications();
            }
        },
        error: function(xhr) {
            console.error('Error marking all notifications as read:', xhr);
        }
    });
}

// Refresh notifications
function refreshNotifications() {
    $.ajax({
        url: '{{ route("kepala.notifications.get") }}',
        type: 'GET',
        success: function(response) {
            // Update unread count in notification badge
            const badge = $('.dropdown-toggle .badge');
            if (response.unread_count > 0) {
                badge.text(response.unread_count).show();
            } else {
                badge.hide();
            }
        },
        error: function(xhr) {
            console.error('Error refreshing notifications:', xhr);
        }
    });
}
</script>
@endpush
