@extends('layouts.app')

@section('title', 'Detail Guru')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Header -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-user-graduate"></i> Detail Guru - {{ $guru->nama_lengkap }}
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('kepala.guru.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Daftar Guru
                        </a>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Guru Information -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-info-circle"></i> Informasi Guru
                            </h3>
                        </div>
                        <div class="card-body">
                            <dl class="row">
                                <dt class="col-sm-5">Nama Lengkap:</dt>
                                <dd class="col-sm-7">
                                    <strong>{{ $guru->nama_lengkap }}</strong>
                                    @if($guru->gelar_depan || $guru->gelar_belakang)
                                        <br><small class="text-muted">{{ $guru->gelar_depan }} {{ $guru->nama_lengkap }}{{ $guru->gelar_belakang ? ', ' . $guru->gelar_belakang : '' }}</small>
                                    @endif
                                </dd>

                                <dt class="col-sm-5">NIP:</dt>
                                <dd class="col-sm-7">{{ $guru->nip ?? '-' }}</dd>

                                <dt class="col-sm-5">NUPTK:</dt>
                                <dd class="col-sm-7">{{ $guru->nuptk ?? '-' }}</dd>

                                <dt class="col-sm-5">Tempat/Tgl Lahir:</dt>
                                <dd class="col-sm-7">{{ $guru->tempat_lahir }}, {{ $guru->tanggal_lahir->format('d F Y') }}</dd>

                                <dt class="col-sm-5">Jenis Kelamin:</dt>
                                <dd class="col-sm-7">{{ $guru->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}</dd>

                                <dt class="col-sm-5">Pendidikan:</dt>
                                <dd class="col-sm-7">{{ $guru->pendidikan_terakhir }}<br>
                                    <small class="text-muted">{{ $guru->jurusan ?? '-' }}</small>
                                </dd>

                                <dt class="col-sm-5">Mata Pelajaran:</dt>
                                <dd class="col-sm-7">{{ $guru->mata_pelajaran }}</dd>

                                <dt class="col-sm-5">Kelas Diampu:</dt>
                                <dd class="col-sm-7">{{ $guru->kelas_diampu }}</dd>

                                <dt class="col-sm-5">Status Kepegawaian:</dt>
                                <dd class="col-sm-7">
                                    <span class="badge badge-{{ $guru->status_kepegawaian == 'PNS' ? 'success' : ($guru->status_kepegawaian == 'PPPK' ? 'info' : 'warning') }}">
                                        {{ $guru->status_kepegawaian }}
                                    </span>
                                </dd>

                                <dt class="col-sm-5">Status Sertifikasi:</dt>
                                <dd class="col-sm-7">
                                    <span class="badge badge-{{ $guru->status_sertifikasi == 'sudah' ? 'success' : 'warning' }}">
                                        {{ $guru->status_sertifikasi == 'sudah' ? 'Sudah' : 'Belum' }}
                                    </span>
                                    @if($guru->tahun_sertifikasi)
                                        <br><small class="text-muted">Tahun: {{ $guru->tahun_sertifikasi }}</small>
                                    @endif
                                </dd>

                                <dt class="col-sm-5">No. Sertifikat:</dt>
                                <dd class="col-sm-7">{{ $guru->no_sertifikat ?? '-' }}</dd>

                                <dt class="col-sm-5">Golongan:</dt>
                                <dd class="col-sm-7">
                                    {{ $guru->golongan ?? '-' }}
                                    @if($guru->tmt_golongan)
                                        <br><small class="text-muted">TMT: {{ $guru->tmt_golongan->format('d/m/Y') }}</small>
                                    @endif
                                </dd>

                                <dt class="col-sm-5">Telepon:</dt>
                                <dd class="col-sm-7">{{ $guru->telepon ?? '-' }}</dd>

                                <dt class="col-sm-5">Alamat:</dt>
                                <dd class="col-sm-7">{{ $guru->alamat }}</dd>
                            </dl>
                        </div>
                    </div>
                </div>

                <!-- Penilaian Statistics -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-chart-bar"></i> Statistik Penilaian
                            </h3>
                        </div>
                        <div class="card-body">
                            <!-- Statistics Cards -->
                            <div class="row mb-4">
                                <div class="col-lg-3 col-6">
                                    <div class="small-box bg-info">
                                        <div class="inner">
                                            <h3>{{ $penilaianStats['total_penilaian'] }}</h3>
                                            <p>Total Penilaian</p>
                                        </div>
                                        <div class="icon">
                                            <i class="fas fa-clipboard-list"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-6">
                                    <div class="small-box bg-secondary">
                                        <div class="inner">
                                            <h3>{{ $penilaianStats['draft'] }}</h3>
                                            <p>Draft</p>
                                        </div>
                                        <div class="icon">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-6">
                                    <div class="small-box bg-warning">
                                        <div class="inner">
                                            <h3>{{ $penilaianStats['submitted'] }}</h3>
                                            <p>Menunggu Review</p>
                                        </div>
                                        <div class="icon">
                                            <i class="fas fa-paper-plane"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-6">
                                    <div class="small-box bg-success">
                                        <div class="inner">
                                            <h3>{{ $penilaianStats['validated'] }}</h3>
                                            <p>Validated</p>
                                        </div>
                                        <div class="icon">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-6">
                                    <div class="small-box bg-primary">
                                        <div class="inner">
                                            <h3>{{ $penilaianStats['final'] }}</h3>
                                            <p>Final</p>
                                        </div>
                                        <div class="icon">
                                            <i class="fas fa-flag-checkered"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Latest Penilaian -->
                            @if($latestPenilaian)
                            <div class="alert alert-info">
                                <h5><i class="fas fa-info-circle"></i> Penilaian Terbaru</h5>
                                <p><strong>Instrumen:</strong> {{ $latestPenilaian->distribusiInstrumen->instrumen->judul }}</p>
                                <p><strong>Status:</strong> 
                                    @switch($latestPenilaian->status)
                                        @case('draft')
                                            <span class="badge badge-secondary">Draft</span>
                                            @break
                                        @case('submitted')
                                            <span class="badge badge-warning">Menunggu Review</span>
                                            @break
                                        @case('revision')
                                            <span class="badge badge-info">Perlu Revisi</span>
                                            @break
                                        @case('validated')
                                            <span class="badge badge-success">Validated</span>
                                            @break
                                        @case('final')
                                            <span class="badge badge-primary">Final</span>
                                            @break
                                    @endswitch
                                </p>
                                @if($latestPenilaian->rata_rata)
                                    <p><strong>Nilai:</strong> {{ number_format($latestPenilaian->rata_rata, 2) }}</p>
                                @endif
                                @if($latestPenilaian->catatan_kepala)
                                    <p><strong>Catatan:</strong> {{ $latestPenilaian->catatan_kepala }}</p>
                                @endif
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Penilaian History -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-history"></i> Riwayat Penilaian
                            </h3>
                        </div>
                        <div class="card-body">
                            @if($penilaianGuru->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Instrumen</th>
                                            <th>Tahun/Semester</th>
                                            <th>Status</th>
                                            <th>Nilai</th>
                                            <th>Tanggal Submit</th>
                                            <th>Tanggal Validasi</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($penilaianGuru as $penilaian)
                                        <tr>
                                            <td>
                                                <strong>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</strong>
                                            </td>
                                            <td>
                                                {{ $penilaian->distribusiInstrumen->instrumen->tahun_ajaran }}
                                                <br><small class="text-muted">Semester {{ $penilaian->distribusiInstrumen->instrumen->semester }}</small>
                                            </td>
                                            <td>
                                                @switch($penilaian->status)
                                                    @case('draft')
                                                        <span class="badge badge-secondary">Draft</span>
                                                        @break
                                                    @case('submitted')
                                                        <span class="badge badge-warning">Menunggu Review</span>
                                                        @break
                                                    @case('revision')
                                                        <span class="badge badge-info">Perlu Revisi</span>
                                                        @break
                                                    @case('validated')
                                                        <span class="badge badge-success">Validated</span>
                                                        @break
                                                    @case('final')
                                                        <span class="badge badge-primary">Final</span>
                                                        @break
                                                @endswitch
                                            </td>
                                            <td>
                                                @if($penilaian->rata_rata)
                                                    <strong>{{ number_format($penilaian->rata_rata, 2) }}</strong>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($penilaian->tanggal_submit)
                                                    {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($penilaian->tanggal_validasi)
                                                    {{ $penilaian->tanggal_validasi->format('d/m/Y H:i') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-info btn-sm" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                
                                                @if($penilaian->status == 'submitted')
                                                    <a href="#" class="btn btn-warning btn-sm" title="Review Penilaian">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="text-center py-4">
                                <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Belum ada penilaian</h5>
                                <p class="text-muted">Guru ini belum memiliki riwayat penilaian.</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush
