@extends('layouts.app')

@section('title', 'Manajemen Guru')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
                        <i class="fas fa-chalkboard-teacher"></i> Manajemen Guru - {{ $lembaga->nama_lembaga }}
        </h3>
        <div class="card-tools">
                        <a href="{{ route('kepala.guru.create') }}" class="btn btn-success btn-sm">
                            <i class="fas fa-user-plus"></i> Tambah Guru
                        </a>
                        <a href="{{ route('kepala.dashboard') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Dashboard
            </a>
        </div>
    </div>
    <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_guru'] }}</h3>
                                    <p>Total Guru</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-chalkboard-teacher"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['active_guru'] }}</h3>
                                    <p>Guru Aktif</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-user-check"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['pending_review'] }}</h3>
                                    <p>Menunggu Review</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{ $stats['guru_with_penilaian'] }}</h3>
                                    <p>Dengan Penilaian</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Active Instruments Alert -->
                    @if($activeInstrumen->count() > 0)
        <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> Instrumen Penilaian Aktif</h5>
                        <p class="mb-2">Saat ini ada {{ $activeInstrumen->count() }} instrumen penilaian yang aktif:</p>
                        <ul class="mb-0">
                            @foreach($activeInstrumen as $instrumen)
                            <li>
                                <strong>{{ $instrumen->instrumen->judul }}</strong> 
                                ({{ $instrumen->instrumen->tahun_ajaran }} - Semester {{ $instrumen->instrumen->semester }})
                                <br>
                                <small class="text-muted">Deadline: {{ $instrumen->deadline->format('d F Y') }}</small>
                                <a href="{{ route('kepala.instrumen.show', $instrumen->id) }}" class="btn btn-sm btn-outline-primary ml-2">
                                    <i class="fas fa-eye"></i> Lihat
                                </a>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    @else
                    <div class="alert alert-warning">
                        <h5><i class="fas fa-exclamation-triangle"></i> Belum Ada Instrumen Aktif</h5>
                        <p class="mb-0">Belum ada instrumen penilaian yang didistribusikan oleh pengawas ke lembaga ini.</p>
                    </div>
                    @endif

                    <!-- Guru Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Guru</th>
                                    <th>NIP/NUPTK</th>
                                    <th>Mata Pelajaran</th>
                                    <th>Kelas</th>
                                    <th>Status Kepegawaian</th>
                                    <th>Status Penilaian</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($guru as $item)
                                <tr>
                                    <td>{{ $loop->iteration + ($guru->currentPage() - 1) * $guru->perPage() }}</td>
                                    <td>
                                        <strong>{{ $item->nama_lengkap }}</strong>
                                        @if($item->gelar_depan || $item->gelar_belakang)
                                            <br><small class="text-muted">{{ $item->gelar_depan }} {{ $item->nama_lengkap }}{{ $item->gelar_belakang ? ', ' . $item->gelar_belakang : '' }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->nip)
                                            <strong>NIP:</strong> {{ $item->nip }}<br>
                                        @endif
                                        @if($item->nuptk)
                                            <strong>NUPTK:</strong> {{ $item->nuptk }}
                                        @endif
                                        @if(!$item->nip && !$item->nuptk)
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->mata_pelajaran ?? '-' }}</td>
                                    <td>{{ $item->kelas_diampu ?? '-' }}</td>
                                    <td>
                                        <span class="badge badge-{{ $item->status_kepegawaian == 'PNS' ? 'success' : ($item->status_kepegawaian == 'PPPK' ? 'info' : 'warning') }}">
                                            {{ $item->status_kepegawaian }}
                                        </span>
                                    </td>
                                    <td>
                                        @php
                                            $latestPenilaian = $item->penilaianGuru->first();
                                        @endphp
                                        @if($latestPenilaian)
                                            @switch($latestPenilaian->status)
                                                @case('draft')
                                                    <span class="badge badge-secondary">
                                                        <i class="fas fa-clock"></i> Draft
                                                    </span>
                                                    <br><small class="text-muted">Belum submit</small>
                                                    @break
                                                @case('submitted')
                                                    <span class="badge badge-warning">
                                                        <i class="fas fa-paper-plane"></i> Menunggu Review
                                                    </span>
                                                    <br><small class="text-muted">{{ $latestPenilaian->tanggal_submit ? $latestPenilaian->tanggal_submit->format('d/m/Y') : '' }}</small>
                                                    @break
                                                @case('revision')
                                                    <span class="badge badge-info">
                                                        <i class="fas fa-edit"></i> Perlu Revisi
                                                    </span>
                                                    <br><small class="text-muted">Perlu diperbaiki</small>
                                                    @break
                                                @case('validated')
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle"></i> Validated
                                                    </span>
                                                    <br><small class="text-muted">Nilai: {{ $latestPenilaian->rata_rata ? number_format($latestPenilaian->rata_rata, 2) : '-' }}</small>
                                                    @break
                                                @case('final')
                                                    <span class="badge badge-primary">
                                                        <i class="fas fa-flag-checkered"></i> Final
                                                    </span>
                                                    <br><small class="text-muted">Sudah disubmit ke pengawas</small>
                                                    @break
                                            @endswitch
                                        @else
                                            <span class="badge badge-light">
                                                <i class="fas fa-minus"></i> Belum Ada
                                            </span>
                                            <br><small class="text-muted">Tidak ada penilaian</small>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('kepala.guru.show', $item->id) }}" class="btn btn-info btn-sm" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        @if($latestPenilaian && $latestPenilaian->status == 'submitted')
                                            <a href="#" class="btn btn-warning btn-sm" title="Review Penilaian">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-chalkboard-teacher fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada guru terdaftar</h5>
                                            <p class="text-muted">Belum ada guru yang terdaftar di lembaga ini.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($guru->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $guru->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush