@extends('layouts.app')

@section('title', 'Tambah Guru')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-user-plus"></i> Tambah Guru Baru - {{ $lembaga->nama_lembaga }}
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('kepala.guru.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Daftar Guru
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('kepala.guru.store') }}" method="POST">
                        @csrf
                        
                        <!-- Informasi Akun -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="fas fa-user"></i> Informasi Akun Login
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="name">Nama User <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                                   id="name" name="name" value="{{ old('name') }}" required>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">Nama yang akan digunakan untuk login</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="email">Email <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                                   id="email" name="email" value="{{ old('email') }}" required>
                                            @error('email')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">Email untuk login dan notifikasi</small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="password">Password <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control @error('password') is-invalid @enderror" 
                                                   id="password" name="password" required>
                                            @error('password')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">Minimal 8 karakter</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="password_confirmation">Konfirmasi Password <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control" 
                                                   id="password_confirmation" name="password_confirmation" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="phone">Nomor Telepon</label>
                                            <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                                   id="phone" name="phone" value="{{ old('phone') }}">
                                            @error('phone')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi Guru -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="fas fa-chalkboard-teacher"></i> Informasi Profil Guru
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nama_lengkap">Nama Lengkap <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nama_lengkap') is-invalid @enderror" 
                                                   id="nama_lengkap" name="nama_lengkap" value="{{ old('nama_lengkap') }}" required>
                                            @error('nama_lengkap')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="gelar_depan">Gelar Depan</label>
                                            <input type="text" class="form-control @error('gelar_depan') is-invalid @enderror" 
                                                   id="gelar_depan" name="gelar_depan" value="{{ old('gelar_depan') }}" 
                                                   placeholder="Dr., S.Pd., M.Pd.">
                                            @error('gelar_depan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="gelar_belakang">Gelar Belakang</label>
                                            <input type="text" class="form-control @error('gelar_belakang') is-invalid @enderror" 
                                                   id="gelar_belakang" name="gelar_belakang" value="{{ old('gelar_belakang') }}" 
                                                   placeholder="M.Pd., S.Pd.">
                                            @error('gelar_belakang')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nip">NIP</label>
                                            <input type="text" class="form-control @error('nip') is-invalid @enderror" 
                                                   id="nip" name="nip" value="{{ old('nip') }}">
                                            @error('nip')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nuptk">NUPTK</label>
                                            <input type="text" class="form-control @error('nuptk') is-invalid @enderror" 
                                                   id="nuptk" name="nuptk" value="{{ old('nuptk') }}">
                                            @error('nuptk')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tempat_lahir">Tempat Lahir <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('tempat_lahir') is-invalid @enderror" 
                                                   id="tempat_lahir" name="tempat_lahir" value="{{ old('tempat_lahir') }}" required>
                                            @error('tempat_lahir')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tanggal_lahir">Tanggal Lahir <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control @error('tanggal_lahir') is-invalid @enderror" 
                                                   id="tanggal_lahir" name="tanggal_lahir" value="{{ old('tanggal_lahir') }}" required>
                                            @error('tanggal_lahir')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="jenis_kelamin">Jenis Kelamin <span class="text-danger">*</span></label>
                                            <select class="form-control @error('jenis_kelamin') is-invalid @enderror" 
                                                    id="jenis_kelamin" name="jenis_kelamin" required>
                                                <option value="">Pilih Jenis Kelamin</option>
                                                <option value="L" {{ old('jenis_kelamin') == 'L' ? 'selected' : '' }}>Laki-laki</option>
                                                <option value="P" {{ old('jenis_kelamin') == 'P' ? 'selected' : '' }}>Perempuan</option>
                                            </select>
                                            @error('jenis_kelamin')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="telepon">Telepon Guru</label>
                                            <input type="text" class="form-control @error('telepon') is-invalid @enderror" 
                                                   id="telepon" name="telepon" value="{{ old('telepon') }}">
                                            @error('telepon')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi Pendidikan -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="fas fa-graduation-cap"></i> Informasi Pendidikan & Jabatan
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="pendidikan_terakhir">Pendidikan Terakhir <span class="text-danger">*</span></label>
                                            <select class="form-control @error('pendidikan_terakhir') is-invalid @enderror" 
                                                    id="pendidikan_terakhir" name="pendidikan_terakhir" required>
                                                <option value="">Pilih Pendidikan</option>
                                                <option value="SMA/SMK" {{ old('pendidikan_terakhir') == 'SMA/SMK' ? 'selected' : '' }}>SMA/SMK</option>
                                                <option value="D1" {{ old('pendidikan_terakhir') == 'D1' ? 'selected' : '' }}>D1</option>
                                                <option value="D2" {{ old('pendidikan_terakhir') == 'D2' ? 'selected' : '' }}>D2</option>
                                                <option value="D3" {{ old('pendidikan_terakhir') == 'D3' ? 'selected' : '' }}>D3</option>
                                                <option value="D4" {{ old('pendidikan_terakhir') == 'D4' ? 'selected' : '' }}>D4</option>
                                                <option value="S1" {{ old('pendidikan_terakhir') == 'S1' ? 'selected' : '' }}>S1</option>
                                                <option value="S2" {{ old('pendidikan_terakhir') == 'S2' ? 'selected' : '' }}>S2</option>
                                                <option value="S3" {{ old('pendidikan_terakhir') == 'S3' ? 'selected' : '' }}>S3</option>
                                            </select>
                                            @error('pendidikan_terakhir')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="jurusan">Jurusan</label>
                                            <input type="text" class="form-control @error('jurusan') is-invalid @enderror" 
                                                   id="jurusan" name="jurusan" value="{{ old('jurusan') }}" 
                                                   placeholder="Pendidikan Matematika, PGSD, dll">
                                            @error('jurusan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="mata_pelajaran">Mata Pelajaran <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('mata_pelajaran') is-invalid @enderror" 
                                                   id="mata_pelajaran" name="mata_pelajaran" value="{{ old('mata_pelajaran') }}" required
                                                   placeholder="Matematika, Bahasa Indonesia, dll">
                                            @error('mata_pelajaran')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="kelas_diampu">Kelas yang Diampu <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('kelas_diampu') is-invalid @enderror" 
                                                   id="kelas_diampu" name="kelas_diampu" value="{{ old('kelas_diampu') }}" required
                                                   placeholder="Kelas 1-3, Kelas 4-6, dll">
                                            @error('kelas_diampu')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="status_kepegawaian">Status Kepegawaian <span class="text-danger">*</span></label>
                                            <select class="form-control @error('status_kepegawaian') is-invalid @enderror" 
                                                    id="status_kepegawaian" name="status_kepegawaian" required>
                                                <option value="">Pilih Status</option>
                                                <option value="PNS" {{ old('status_kepegawaian') == 'PNS' ? 'selected' : '' }}>PNS</option>
                                                <option value="PPPK" {{ old('status_kepegawaian') == 'PPPK' ? 'selected' : '' }}>PPPK</option>
                                                <option value="GTY" {{ old('status_kepegawaian') == 'GTY' ? 'selected' : '' }}>GTY</option>
                                                <option value="GTT" {{ old('status_kepegawaian') == 'GTT' ? 'selected' : '' }}>GTT</option>
                                            </select>
                                            @error('status_kepegawaian')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="golongan">Golongan</label>
                                            <input type="text" class="form-control @error('golongan') is-invalid @enderror" 
                                                   id="golongan" name="golongan" value="{{ old('golongan') }}" 
                                                   placeholder="III/a, IV/b, dll">
                                            @error('golongan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tmt_golongan">TMT Golongan</label>
                                            <input type="date" class="form-control @error('tmt_golongan') is-invalid @enderror" 
                                                   id="tmt_golongan" name="tmt_golongan" value="{{ old('tmt_golongan') }}">
                                            @error('tmt_golongan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi Sertifikasi -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="fas fa-certificate"></i> Informasi Sertifikasi
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="status_sertifikasi">Status Sertifikasi <span class="text-danger">*</span></label>
                                            <select class="form-control @error('status_sertifikasi') is-invalid @enderror" 
                                                    id="status_sertifikasi" name="status_sertifikasi" required>
                                                <option value="">Pilih Status</option>
                                                <option value="sudah" {{ old('status_sertifikasi') == 'sudah' ? 'selected' : '' }}>Sudah</option>
                                                <option value="belum" {{ old('status_sertifikasi') == 'belum' ? 'selected' : '' }}>Belum</option>
                                            </select>
                                            @error('status_sertifikasi')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tahun_sertifikasi">Tahun Sertifikasi</label>
                                            <input type="number" class="form-control @error('tahun_sertifikasi') is-invalid @enderror" 
                                                   id="tahun_sertifikasi" name="tahun_sertifikasi" value="{{ old('tahun_sertifikasi') }}" 
                                                   min="1990" max="{{ date('Y') }}">
                                            @error('tahun_sertifikasi')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="no_sertifikat">No. Sertifikat</label>
                                            <input type="text" class="form-control @error('no_sertifikat') is-invalid @enderror" 
                                                   id="no_sertifikat" name="no_sertifikat" value="{{ old('no_sertifikat') }}">
                                            @error('no_sertifikat')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="status_inpassing">Status Inpassing <span class="text-danger">*</span></label>
                                            <select class="form-control @error('status_inpassing') is-invalid @enderror" 
                                                    id="status_inpassing" name="status_inpassing" required>
                                                <option value="">Pilih Status</option>
                                                <option value="sudah" {{ old('status_inpassing') == 'sudah' ? 'selected' : '' }}>Sudah</option>
                                                <option value="belum" {{ old('status_inpassing') == 'belum' ? 'selected' : '' }}>Belum</option>
                                            </select>
                                            @error('status_inpassing')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Alamat -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="fas fa-map-marker-alt"></i> Alamat
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="alamat">Alamat Lengkap <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                              id="alamat" name="alamat" rows="3" required>{{ old('alamat') }}</textarea>
                                    @error('alamat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Guru
                            </button>
                            <a href="{{ route('kepala.guru.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);

    // Auto-fill nama_lengkap from name field
    $('#name').on('blur', function() {
        if (!$('#nama_lengkap').val()) {
            $('#nama_lengkap').val($(this).val());
        }
    });

    // Auto-fill email as default password hint
    $('#email').on('blur', function() {
        const email = $(this).val();
        if (email && !$('#password').val()) {
            // Suggest password based on email prefix
            const emailPrefix = email.split('@')[0];
            $('#password').val(emailPrefix + '123');
            $('#password_confirmation').val(emailPrefix + '123');
        }
    });
});
</script>
@endpush