@extends('layouts.app')

@section('title', 'Dashboard Kepala Madrasah')

@section('breadcrumb')
<li class="breadcrumb-item active">Dashboard</li>
@endsection

@section('content')
<!-- Info boxes -->
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info elevation-1"><i class="fas fa-chalkboard-teacher"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Guru</span>
                <span class="info-box-number">{{ $stats['total_guru'] }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-clipboard-list"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Instrumen Diterima</span>
                <span class="info-box-number">{{ $stats['total_instrumen_distributed'] }}</span>
            </div>
        </div>
    </div>
    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-star"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Penilaian Berlangsung</span>
                <span class="info-box-number">{{ $stats['penilaian_by_status']['draft'] + $stats['penilaian_by_status']['submitted'] }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-check-circle"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Sudah Divalidasi</span>
                <span class="info-box-number">{{ $stats['penilaian_by_status']['validated'] + $stats['penilaian_by_status']['final'] }}</span>
            </div>
        </div>
    </div>
</div>

<!-- Data Lembaga Status -->
@php
    $lembagaFields = [
        'alamat_lengkap' => $lembaga->alamat_lengkap,
        'kelurahan' => $lembaga->kelurahan,
        'kecamatan' => $lembaga->kecamatan,
        'kabupaten' => $lembaga->kabupaten,
        'provinsi' => $lembaga->provinsi,
        'kode_pos' => $lembaga->kode_pos,
        'telepon' => $lembaga->telepon,
        'email' => $lembaga->email,
        'akreditasi' => $lembaga->akreditasi,
        'tahun_berdiri' => $lembaga->tahun_berdiri,
    ];
    $emptyFields = array_filter($lembagaFields, function($value) {
        return empty($value);
    });
    $completenessPercentage = round((count($lembagaFields) - count($emptyFields)) / count($lembagaFields) * 100, 1);
@endphp

@if(count($emptyFields) > 0)
<div class="row">
    <div class="col-12">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <h4 class="alert-heading">
                <i class="fas fa-exclamation-triangle"></i> Data Lembaga Belum Lengkap!
            </h4>
            <p class="mb-2">Kelengkapan data lembaga Anda saat ini: <strong>{{ $completenessPercentage }}%</strong></p>
            <p class="mb-3">Silakan lengkapi data lembaga untuk memaksimalkan penggunaan sistem.</p>
            <hr>
            <div class="row">
                <div class="col-md-6">
                    <h6>Field yang masih kosong:</h6>
                    <ul class="mb-0">
                        @foreach($emptyFields as $field => $value)
                            <li>{{ ucfirst(str_replace('_', ' ', $field)) }}</li>
                        @endforeach
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>Aksi yang dapat dilakukan:</h6>
                    <a href="{{ route('kepala.lembaga.edit') }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Lengkapi Data Lembaga
                    </a>
                    <a href="{{ route('kepala.lembaga.index') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-info-circle"></i> Lihat Detail Lembaga
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@else
<div class="row">
    <div class="col-12">
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <h4 class="alert-heading">
                <i class="fas fa-check-circle"></i> Data Lembaga Sudah Lengkap!
            </h4>
            <p class="mb-0">Selamat! Data lembaga Anda sudah lengkap ({{ $completenessPercentage }}%).</p>
        </div>
    </div>
</div>
@endif

<!-- Main row -->
<div class="row">
    <!-- Lembaga Information Card -->
    <div class="col-md-4">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-school"></i> Informasi Lembaga
                </h3>
                <div class="card-tools">
                    <a href="{{ route('kepala.lembaga.index') }}" class="btn btn-tool">
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <h5 class="text-primary">{{ $lembaga->nama_lembaga }}</h5>
                <p class="text-muted mb-2">
                    <strong>NSM:</strong> {{ $lembaga->npsn_nsm }}<br>
                    <strong>Jenis:</strong> 
                    <span class="badge badge-{{ $lembaga->jenis == 'RA' ? 'primary' : ($lembaga->jenis == 'MI' ? 'success' : ($lembaga->jenis == 'MTs' ? 'info' : 'warning')) }}">
                        {{ $lembaga->jenis }}
                    </span>
                </p>
                
                @if($lembaga->alamat_lengkap)
                    <p class="text-muted mb-2">
                        <strong>Alamat:</strong><br>
                        {{ $lembaga->alamat_lengkap }}<br>
                        {{ $lembaga->kelurahan_name ?? $lembaga->kelurahan }}, {{ $lembaga->kecamatan_name ?? $lembaga->kecamatan }}<br>
                        {{ $lembaga->kabupaten_name ?? $lembaga->kabupaten }}, {{ $lembaga->provinsi_name ?? $lembaga->provinsi }} {{ $lembaga->kode_pos }}
                    </p>
                @else
                    <div class="alert alert-warning alert-sm">
                        <i class="fas fa-exclamation-triangle"></i> Alamat belum dilengkapi
                    </div>
                @endif
                
                @if($lembaga->telepon || $lembaga->email)
                    <p class="text-muted mb-2">
                        @if($lembaga->telepon)
                            <strong>Telepon:</strong> {{ $lembaga->telepon }}<br>
                        @endif
                        @if($lembaga->email)
                            <strong>Email:</strong> {{ $lembaga->email }}<br>
                        @endif
                    </p>
                @endif
                
                <div class="mt-3">
                    <a href="{{ route('kepala.lembaga.edit') }}" class="btn btn-primary btn-sm btn-block">
                        <i class="fas fa-edit"></i> Edit Data Lembaga
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Guru di Lembaga</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Guru</th>
                                <th>Mata Pelajaran</th>
                                <th>Kelas</th>
                                <th>Status Kepegawaian</th>
                                <th>Status Sertifikasi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse(\App\Models\Guru::where('lembaga_id', $lembaga->id)->take(5)->get() as $guru)
                            <tr>
                                <td>{{ $guru->nama_lengkap_with_gelar }}</td>
                                <td>{{ $guru->mata_pelajaran }}</td>
                                <td>{{ $guru->kelas_diampu }}</td>
                                <td><span class="badge badge-info">{{ $guru->status_kepegawaian }}</span></td>
                                <td><span class="badge badge-{{ $guru->status_sertifikasi == 'sudah' ? 'success' : 'warning' }}">{{ ucfirst($guru->status_sertifikasi) }}</span></td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">Belum ada guru terdaftar</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Instrumen Penilaian</h3>
                <div class="card-tools">
                    <a href="{{ route('kepala.instrumen.index') }}" class="btn btn-tool">
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                @php
                    $user = Auth::user();
                    $lembaga = $user->lembagaKepala()->first();
                    $recentInstrumen = $lembaga ? \App\Models\DistribusiInstrumen::with(['instrumen', 'komponen'])
                        ->where('lembaga_id', $lembaga->id)
                        ->latest()
                        ->take(3)
                        ->get() : collect();
                @endphp
                
                @if($recentInstrumen->count() > 0)
                    <ul class="list-group list-group-flush">
                        @foreach($recentInstrumen as $distribusi)
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">{{ Str::limit($distribusi->instrumen->judul, 30) }}</h6>
                                <small class="text-muted">{{ $distribusi->instrumen->tahun_ajaran }} - Semester {{ $distribusi->instrumen->semester }}</small>
                                <br>
                                <small class="text-muted">{{ $distribusi->tanggal_distribusi->format('d/m/Y') }}</small>
                                @if($distribusi->komponen)
                                    <br><span class="badge badge-info badge-sm">
                                        <i class="fas fa-puzzle-piece"></i> {{ $distribusi->komponen->nama_komponen }}
                                    </span>
                                @else
                                    <br><span class="badge badge-success badge-sm">
                                        <i class="fas fa-check-circle"></i> Semua
                                    </span>
                                @endif
                            </div>
                            <div class="text-right">
                                @if($distribusi->status == 'active')
                                    <span class="badge badge-success">Aktif</span>
                                @else
                                    <span class="badge badge-secondary">Ditutup</span>
                                @endif
                                <br>
                                <a href="{{ route('kepala.instrumen.show', $distribusi->id) }}" class="btn btn-sm btn-primary mt-1">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                    <div class="mt-3">
                        <a href="{{ route('kepala.instrumen.index') }}" class="btn btn-primary btn-sm btn-block">
                            <i class="fas fa-clipboard-list"></i> Lihat Semua Instrumen
                        </a>
                    </div>
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-clipboard-list fa-2x text-muted mb-2"></i>
                        <p class="text-muted mb-0">Belum ada instrumen</p>
                        <small class="text-muted">Pengawas belum mendistribusikan instrumen</small>
                    </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Penilaian Terbaru</h3>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    @forelse(\App\Models\PenilaianKepala::where('kepala_id', Auth::id())->latest()->take(3)->get() as $penilaian)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1">{{ $penilaian->distribusiInstrumen->instrumen->judul }}</h6>
                            <small class="text-muted">Oleh Pengawas: {{ $penilaian->pengawas?->name ?? '-' }}</small>
                        </div>
                        <span class="badge badge-{{ in_array($penilaian->status, ['validated','final']) ? 'success' : ($penilaian->status == 'submitted' ? 'warning' : 'info') }}">
                            {{ ucfirst($penilaian->status) }}
                        </span>
                    </li>
                    @empty
                    <li class="list-group-item text-center text-muted">Belum ada penilaian</li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection