{{-- Validation Page --}}
<div class="card">
    <div class="card-header">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">
                <i class="fas fa-check-circle"></i> Validasi & Submit Instrumen
            </h5>
            <div>
                <a href="{{ route('guru.instrumen.isi') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        @php
            $totalItems = $allItems->count();
            $completedItems = $progress ? $progress->where('status', 'complete')->count() : 0;
            $partialItems = $progress ? $progress->where('status', 'partial')->count() : 0;
            $emptyItems = $progress ? $progress->where('status', 'empty')->count() : $totalItems;
            $progressPercentage = $totalItems > 0 ? round(($completedItems / $totalItems) * 100) : 0;
        @endphp

        <!-- Progress Summary -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h3>{{ $completedItems }}</h3>
                        <small>Lengkap</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h3>{{ $partialItems }}</h3>
                        <small>Belum Lengkap</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-secondary text-white">
                    <div class="card-body text-center">
                        <h3>{{ $emptyItems }}</h3>
                        <small>Belum Diisi</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h3>{{ $progressPercentage }}%</h3>
                        <small>Progress</small>
                    </div>
                </div>
            </div>
        </div>

        @if($completedItems == $totalItems)
            <!-- All Items Completed -->
            <div class="alert alert-success">
                <h5><i class="fas fa-check-circle"></i> Selamat! Semua item telah diisi dengan lengkap</h5>
                <p class="mb-0">Anda dapat melakukan submit instrumen ke kepala Madrasah untuk review.</p>
            </div>

            <!-- Review All Answers -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list"></i> Review Jawaban Anda
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="40%">Indikator</th>
                                    <th width="25%">URL Bukti</th>
                                    <th width="10%">Nilai</th>
                                    <th width="20%">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($allItems && $allItems->count() > 0)
                                    @foreach($allItems as $index => $item)
                                        @php
                                            $jawaban = $penilaianGuru->jawabanGuru->firstWhere('instrumen_item_id', $item['id']);
                                        @endphp
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                <small>{{ Str::limit($item['indikator'], 60) }}</small>
                                            </td>
                                            <td>
                                                @if($jawaban && $jawaban->url_bukti)
                                                    <a href="{{ $jawaban->url_bukti }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-external-link-alt"></i> Lihat
                                                    </a>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban && $jawaban->nilai_guru_self)
                                                    <span class="badge badge-info">{{ $jawaban->nilai_guru_self }}</span>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban && $jawaban->keterangan_bukti)
                                                    <small>{{ Str::limit($jawaban->keterangan_bukti, 40) }}</small>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">
                                            <i class="fas fa-info-circle"></i> Tidak ada item instrumen
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Submit Form -->
            <form action="{{ route('guru.instrumen.store', $penilaianGuru->id) }}" method="POST" id="finalSubmitForm">
                @csrf
                <input type="hidden" name="final_submit" value="1">
                
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-paper-plane"></i> Submit Instrumen
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="confirm_submit" required>
                            <label class="form-check-label" for="confirm_submit">
                                <strong>Saya menyatakan bahwa semua jawaban yang diberikan adalah benar dan dapat dipertanggungjawabkan.</strong>
                            </label>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>Perhatian:</strong> Setelah submit, Anda tidak dapat mengubah jawaban kecuali kepala Madrasah meminta revisi.
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-success btn-lg" id="submitBtn" disabled>
                                <i class="fas fa-paper-plane"></i> Submit ke Kepala Madrasah
                            </button>
                            <a href="{{ route('guru.instrumen.show', [$penilaianGuru->id, 'item_id' => $allItems->first()['id']]) }}" 
                               class="btn btn-secondary btn-lg">
                                <i class="fas fa-edit"></i> Edit Jawaban
                            </a>
                        </div>
                    </div>
                </div>
            </form>

        @else
            <!-- Incomplete Items -->
            <div class="alert alert-warning">
                <h5><i class="fas fa-exclamation-triangle"></i> Masih ada item yang belum lengkap</h5>
                <p class="mb-0">Silakan lengkapi semua item sebelum melakukan submit.</p>
            </div>

            <!-- Incomplete Items List -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list"></i> Item yang Belum Lengkap
                    </h6>
                </div>
                <div class="card-body">
                    @if($allItems && $allItems->count() > 0)
                        @foreach($allItems as $index => $item)
                            @php
                                $itemProgress = $progress ? $progress->firstWhere('id', $item['id']) : null;
                                $status = $itemProgress['status'] ?? 'empty';
                            @endphp
                            @if($status != 'complete')
                            <div class="d-flex align-items-center mb-2 p-2 {{ $status == 'partial' ? 'bg-warning-light' : 'bg-light' }} rounded">
                                <div class="me-3">
                                    @if($status == 'partial')
                                        <i class="fas fa-clock text-warning"></i>
                                    @else
                                        <i class="fas fa-circle text-muted"></i>
                                    @endif
                                </div>
                                <div class="flex-grow-1">
                                    <strong>Item {{ $index + 1 }}:</strong> {{ $item['indikator'] }}
                                </div>
                                <div>
                                    <a href="{{ route('guru.instrumen.show', [$penilaianGuru->id, 'item_id' => $item['id']]) }}" 
                                       class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i> {{ $status == 'partial' ? 'Lengkapi' : 'Isi' }}
                                    </a>
                                </div>
                            </div>
                            @endif
                        @endforeach
                    @else
                        <div class="text-center py-3">
                            <i class="fas fa-info-circle fa-2x text-muted mb-2"></i>
                            <p class="text-muted mb-0">Tidak ada item instrumen</p>
                        </div>
                    @endif
                </div>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    console.log('=== VALIDATION PAGE DEBUG ===');
    console.log('Page loaded:', window.location.href);
    console.log('Form action:', $('#finalSubmitForm').attr('action'));
    console.log('Submit button:', $('#submitBtn').length);
    console.log('Checkbox:', $('#confirm_submit').length);
    
    // Enable submit button when checkbox is checked
    $('#confirm_submit').on('change', function() {
        console.log('Checkbox changed:', this.checked);
        $('#submitBtn').prop('disabled', !this.checked);
        console.log('Submit button disabled:', $('#submitBtn').prop('disabled'));
    });

    // Final submit confirmation
    $('#finalSubmitForm').on('submit', function(e) {
        console.log('=== FORM SUBMIT DEBUG ===');
        console.log('Form submitted to:', $(this).attr('action'));
        console.log('Form method:', $(this).attr('method'));
        console.log('Final submit value:', $('input[name="final_submit"]').val());
        console.log('Checkbox checked:', $('#confirm_submit').is(':checked'));
        
        if (!confirm('Apakah Anda yakin ingin submit instrumen ini? Setelah submit, Anda tidak dapat mengubah jawaban.')) {
            console.log('Submit cancelled by user');
            e.preventDefault();
            return false;
        }
        
        console.log('Submit confirmed, proceeding...');
    });
    
    // Debug button clicks
    $('#submitBtn').on('click', function(e) {
        console.log('=== SUBMIT BUTTON CLICK DEBUG ===');
        console.log('Button clicked');
        console.log('Button disabled:', $(this).prop('disabled'));
        console.log('Checkbox checked:', $('#confirm_submit').is(':checked'));
        
        if ($(this).prop('disabled')) {
            console.log('Button is disabled, preventing click');
            e.preventDefault();
            return false;
        }
    });
    
    // Debug any redirects
    $(window).on('beforeunload', function() {
        console.log('Page is about to redirect/navigate away');
    });
});
</script>
@endpush

@push('styles')
<style>
.bg-warning-light {
    background-color: #fff3cd !important;
}
</style>
@endpush
