@extends('layouts.app')

@section('title', 'Struktur Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('guru.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Struktur</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-list-alt"></i> Struktur Instrumen: {{ $penilaianGuru->distribusiInstrumen->instrumen->judul }}
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('guru.instrumen.isi') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="{{ route('guru.instrumen.show', $penilaianGuru->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Mulai Isi
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Instrumen Information -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-info-circle"></i> Informasi Instrumen
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-3">Judul Instrumen:</dt>
                                        <dd class="col-sm-9">
                                            <strong>{{ $penilaianGuru->distribusiInstrumen->instrumen->judul }}</strong>
                                        </dd>

                                        <dt class="col-sm-3">Tahun Ajaran:</dt>
                                        <dd class="col-sm-9">{{ $penilaianGuru->distribusiInstrumen->instrumen->tahun_ajaran }} - Semester {{ $penilaianGuru->distribusiInstrumen->instrumen->semester }}</dd>

                                        @if($penilaianGuru->distribusiInstrumen->instrumen->deskripsi)
                                        <dt class="col-sm-3">Deskripsi:</dt>
                                        <dd class="col-sm-9">{{ $penilaianGuru->distribusiInstrumen->instrumen->deskripsi }}</dd>
                                        @endif

                                        <dt class="col-sm-3">Deadline:</dt>
                                        <dd class="col-sm-9">
                                            {{ $penilaianGuru->distribusiInstrumen->deadline->format('d F Y') }}
                                            @if($penilaianGuru->distribusiInstrumen->deadline->isPast())
                                                <span class="badge badge-danger ml-2">Terlambat</span>
                                            @elseif($penilaianGuru->distribusiInstrumen->deadline->diffInDays() <= 7)
                                                <span class="badge badge-warning ml-2">Mendekati Deadline</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Status:</dt>
                                        <dd class="col-sm-9">
                                            @switch($penilaianGuru->status)
                                                @case('draft')
                                                    <span class="badge badge-secondary">
                                                        <i class="fas fa-clock"></i> Belum Dikerjakan
                                                    </span>
                                                    @break
                                                @case('submitted')
                                                    <span class="badge badge-warning">
                                                        <i class="fas fa-paper-plane"></i> Menunggu Review
                                                    </span>
                                                    @break
                                                @case('revision')
                                                    <span class="badge badge-info">
                                                        <i class="fas fa-edit"></i> Perlu Revisi
                                                    </span>
                                                    @break
                                                @case('validated')
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle"></i> Sudah Divalidasi
                                                    </span>
                                                    @break
                                            @endswitch
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-chart-pie"></i> Progress
                                    </h4>
                                </div>
                                <div class="card-body">
                                    @php
                                        $totalItems = $allItems->count();
                                        $completedItems = $progress->where('status', 'complete')->count();
                                        $progressPercentage = $totalItems > 0 ? round(($completedItems / $totalItems) * 100) : 0;
                                    @endphp
                                    
                                    <div class="text-center mb-3">
                                        <h3 class="text-primary">{{ $progressPercentage }}%</h3>
                                        <small class="text-muted">Progress Penyelesaian</small>
                                    </div>
                                    
                                    <div class="progress mb-3" style="height: 20px;">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ $progressPercentage }}%">
                                            {{ $progressPercentage }}%
                                        </div>
                                    </div>
                                    
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <h4 class="text-success">{{ $completedItems }}</h4>
                                            <small class="text-muted">Lengkap</small>
                                        </div>
                                        <div class="col-6">
                                            <h4 class="text-warning">{{ $totalItems - $completedItems }}</h4>
                                            <small class="text-muted">Belum</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Struktur Instrumen Hierarkis -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-list-alt"></i> Struktur Instrumen Penilaian
                            </h4>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th width="8%">No</th>
                                            <th width="35%">Indikator Kerja</th>
                                            <th width="30%">Evidensi Kerja</th>
                                            <th width="8%">Skor Min</th>
                                            <th width="8%">Skor Max</th>
                                            <th width="11%">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                                        @endphp
                                        
                                        @php
                                            $currentKomponen = null;
                                            $currentSubKomponen = null;
                                            $subKomponenIndex = 0;
                                            $komponenIndex = 0;
                                        @endphp
                                        
                                        @foreach($allItems as $index => $item)
                                            @php
                                                $itemProgress = $progress->firstWhere('id', $item['id']);
                                                $status = $itemProgress['status'] ?? 'empty';
                                                
                                                // Check if this is a new komponen
                                                if ($currentKomponen !== $item['komponen']) {
                                                    $currentKomponen = $item['komponen'];
                                                    $komponenIndex++;
                                                    $subKomponenIndex = 0;
                                                }
                                                
                                                // Check if this is a new sub komponen
                                                if ($currentSubKomponen !== $item['sub_komponen']) {
                                                    $currentSubKomponen = $item['sub_komponen'];
                                                    $subKomponenIndex++;
                                                }
                                            @endphp
                                            
                                            @if($index === 0 || $currentKomponen !== $allItems[$index - 1]['komponen'])
                                                <!-- Komponen Row (Level Tertinggi) -->
                                                <tr class="table-dark">
                                                    <td><strong>{{ $komponenIndex }}</strong></td>
                                                    <td>
                                                        <strong>{{ $item['komponen'] }}</strong>
                                                    </td>
                                                    <td colspan="3">
                                                        <span class="badge badge-dark">Komponen</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-dark">Komponen</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            
                                            @if($index === 0 || $currentSubKomponen !== $allItems[$index - 1]['sub_komponen'])
                                                <!-- Sub Komponen Row (A, B, C, dst.) -->
                                                <tr class="table-primary">
                                                    <td><strong>{{ $komponenLetters[$subKomponenIndex - 1] }}</strong></td>
                                                    <td>
                                                        <strong>{{ $item['sub_komponen'] }}</strong>
                                                    </td>
                                                    <td colspan="3">
                                                        <span class="badge badge-info">Sub Komponen</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-primary">Sub Komponen</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            
                                            <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                            <tr class="table-light">
                                                <td>
                                                    <strong>{{ $komponenLetters[$subKomponenIndex - 1] }}{{ $item['no_urutan'] ?? ($index + 1) }}</strong>
                                                </td>
                                                <td>
                                                    <div class="text-sm">
                                                        <strong>{{ $item['indikator'] }}</strong>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="text-sm">
                                                        {{ $item['evidensi'] ?: '-' }}
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge badge-success">{{ $item['skor_min'] ?? 1 }}</span>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge badge-danger">{{ $item['skor_max'] ?? 4 }}</span>
                                                </td>
                                                <td>
                                                    @if($status == 'complete')
                                                        <span class="badge badge-success">
                                                            <i class="fas fa-check"></i> Lengkap
                                                        </span>
                                                    @elseif($status == 'partial')
                                                        <span class="badge badge-warning">
                                                            <i class="fas fa-clock"></i> Belum Lengkap
                                                        </span>
                                                    @else
                                                        <span class="badge badge-secondary">
                                                            <i class="fas fa-circle"></i> Belum Diisi
                                                        </span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
