@extends('layouts.app')

@section('title', 'Isi Instrumen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('guru.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('guru.instrumen.isi') }}">Isi</a></li>
<li class="breadcrumb-item active">Form</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Navigation Sidebar -->
        <div class="col-md-3">
            <div class="card sticky-top" style="top: 20px;">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list-ol"></i> Progress Instrumen
                    </h5>
                </div>
                <div class="card-body p-2">
                    <!-- Instrument Info -->
                    <div class="mb-3 p-2 bg-light rounded">
                        <h6 class="mb-1">{{ $penilaianGuru->distribusiInstrumen->instrumen->judul }}</h6>
                        <small class="text-muted">
                            {{ $penilaianGuru->distribusiInstrumen->instrumen->tahun_ajaran }} - Semester {{ $penilaianGuru->distribusiInstrumen->instrumen->semester }}
                        </small>
                        <br>
                        <small class="text-muted">
                            Deadline: {{ $penilaianGuru->distribusiInstrumen->deadline->format('d/m/Y') }}
                        </small>
                    </div>

                    <!-- Progress Stats -->
                    @php
                        $totalItems = $allItems->count();
                        $completedItems = $progress->where('status', 'complete')->count();
                        $partialItems = $progress->where('status', 'partial')->count();
                        $emptyItems = $progress->where('status', 'empty')->count();
                        $progressPercentage = $totalItems > 0 ? round(($completedItems / $totalItems) * 100) : 0;
                    @endphp

                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-1">
                            <small>Progress</small>
                            <small>{{ $progressPercentage }}%</small>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $progressPercentage }}%"></div>
                        </div>
                    </div>

                    <!-- Item Navigation -->
                    <div class="item-navigation">
                        @foreach($allItems as $index => $item)
                            @php
                                $itemProgress = $progress->firstWhere('id', $item['id']);
                                $status = $itemProgress['status'] ?? 'empty';
                                $isCurrent = $itemProgress['current'] ?? false;
                            @endphp
                            <a href="{{ route('guru.instrumen.show', [$penilaianGuru->id, 'item_id' => $item['id']]) }}" 
                               class="nav-item d-block mb-2 p-2 rounded text-decoration-none {{ $isCurrent ? 'current' : '' }}"
                               data-status="{{ $status }}"
>
                                <div class="d-flex align-items-center">
                                    <div class="nav-number me-2 {{ $status }}-number {{ $isCurrent ? 'current' : '' }}">
                                        {{ $index + 1 }}
                                    </div>
                                    <div class="flex-grow-1">
                                        <small class="nav-title d-block text-truncate" style="max-width: 150px;">
                                            {{ $item['indikator'] }}
                                        </small>
                                        <small class="nav-status text-muted">
                                            @if($status == 'complete')
                                                <i class="fas fa-check text-success"></i> Lengkap
                                            @elseif($status == 'partial')
                                                <i class="fas fa-clock text-warning"></i> Belum Lengkap
                                            @else
                                                <i class="fas fa-circle text-muted"></i> Belum Diisi
                                            @endif
                                        </small>
                                    </div>
                                </div>
                            </a>
                        @endforeach

                        <!-- Validation Step -->
                        <a href="{{ route('guru.instrumen.show', [$penilaianGuru->id, 'item_id' => 'validation']) }}" 
                           class="nav-item d-block mb-2 p-2 rounded text-decoration-none {{ request('item_id') == 'validation' ? 'current' : '' }}"
                           data-status="{{ $completedItems == $totalItems ? 'complete' : 'empty' }}">
                            <div class="d-flex align-items-center">
                                <div class="nav-number me-2 validation-number {{ request('item_id') == 'validation' ? 'current' : '' }}">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <small class="nav-title d-block">Validasi & Submit</small>
                                    <small class="nav-status text-muted">
                                        @if($completedItems == $totalItems)
                                            <i class="fas fa-check text-success"></i> Siap Submit
                                        @else
                                            <i class="fas fa-lock text-muted"></i> Belum Siap
                                        @endif
                                    </small>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="col-md-9">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    {{ session('error') }}
                </div>
            @endif

            <!-- Validation Page -->
            @if(request('item_id') == 'validation')
                @include('guru.instrumen.validation', compact('penilaianGuru', 'allItems', 'progress'))
            @else
            <!-- Single Item Form -->
            @php
                $currentItemId = request('item_id', $allItems->first()['id'] ?? null);
                $currentItem = $allItems->firstWhere('id', $currentItemId);
                $currentIndex = $allItems->search(function($item) use ($currentItemId) { return $item['id'] == $currentItemId; });
                
                // Fallback if current item not found
                if (!$currentItem && $allItems->count() > 0) {
                    $currentItem = $allItems->first();
                    $currentItemId = $currentItem['id'];
                    $currentIndex = 0;
                }
            @endphp
            
            @if($currentItem)
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-edit"></i> 
                            Item {{ $currentIndex + 1 }} dari {{ $allItems->count() }}
                        </h5>
                        <div>
                            <a href="{{ route('guru.instrumen.isi') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Item Information -->
                    <div class="mb-4">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="card-title">{{ $currentItem['komponen'] }}</h6>
                                @if(isset($currentItem['sub_komponen']))
                                    <h6 class="card-title text-success">
                                        <i class="fas fa-layer-group"></i> {{ $currentItem['sub_komponen'] }}
                                    </h6>
                                @endif
                                <h5 class="mb-3">{{ $currentItem['indikator'] }}</h5>
                                @if($currentItem['evidensi'])
                                    <p class="mb-0"><strong>Evidensi yang diperlukan:</strong><br>{{ $currentItem['evidensi'] }}</p>
                                @endif
                                <div class="alert alert-info mt-3 mb-0">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>Informasi:</strong> Anda hanya perlu mengisi URL bukti dan keterangan bukti. Penilaian akan dilakukan oleh kepala Madrasah.
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Form -->
                    <form action="{{ route('guru.instrumen.store', $penilaianGuru->id) }}" method="POST">
                        @csrf
                        <input type="hidden" name="item_id" value="{{ $currentItem['id'] }}">
                            
                            <div class="form-group">
                                <label for="url_bukti">URL Bukti <span class="text-danger">*</span></label>
                                <input type="url" 
                                       class="form-control @error('url_bukti') is-invalid @enderror" 
                                       id="url_bukti" 
                                       name="url_bukti" 
                                       value="{{ $existingAnswer->url_bukti ?? old('url_bukti') }}"
                                       placeholder="https://drive.google.com/file/..."
                                       required>
                                @error('url_bukti')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    <i class="fas fa-info-circle"></i> 
                                    Contoh: Google Drive, OneDrive, Dropbox, atau platform berbagi file lainnya
                                </small>
                            </div>

                            <div class="form-group">
                                <label for="keterangan_bukti">Keterangan Bukti <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('keterangan_bukti') is-invalid @enderror" 
                                          id="keterangan_bukti" 
                                          name="keterangan_bukti" 
                                          rows="4" 
                                          placeholder="Jelaskan secara detail bukti yang Anda lampirkan..."
                                          required>{{ $existingAnswer->keterangan_bukti ?? old('keterangan_bukti') }}</textarea>
                                @error('keterangan_bukti')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    <i class="fas fa-lightbulb"></i> 
                                    Tips: Jelaskan isi dokumen, tanggal, dan relevansinya dengan indikator penilaian
                                </small>
                            </div>

                            @if($existingAnswer && $existingAnswer->url_bukti)
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>Bukti sebelumnya:</strong> 
                                <a href="{{ $existingAnswer->url_bukti }}" target="_blank" class="alert-link">
                                    Lihat bukti yang sudah diupload
                                </a>
                            </div>
                            @endif

                            <!-- Action Buttons -->
                            <div class="form-group mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Simpan & Lanjutkan
                                </button>
                                
                                @if($currentIndex > 0)
                                <a href="{{ route('guru.instrumen.show', [$penilaianGuru->id, 'item_id' => $allItems[$currentIndex - 1]['id']]) }}" 
                                   class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Sebelumnya
                                </a>
                                @endif

                                <a href="{{ route('guru.instrumen.isi') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times"></i> Batal
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            @else
                <div class="alert alert-warning">
                    <h5><i class="fas fa-exclamation-triangle"></i> Item Tidak Ditemukan</h5>
                    <p>Item instrumen yang Anda cari tidak ditemukan.</p>
                    <a href="{{ route('guru.instrumen.isi') }}" class="btn btn-primary">
                        <i class="fas fa-arrow-left"></i> Kembali ke Daftar Instrumen
                    </a>
                </div>
            @endif
            @endif
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.item-navigation .nav-item {
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.item-navigation .nav-item:hover {
    background-color: #f8f9fa;
    border-color: #dee2e6;
}

.item-navigation .nav-item.current {
    background-color: #e3f2fd;
    border-color: #2196f3;
}

.nav-number {
    width: 30px;
    height: 30px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 12px;
    color: white;
    transition: all 0.3s ease;
}

.nav-number.complete-number {
    background-color: #28a745;
}

.nav-number.partial-number {
    background-color: #ffc107;
}

.nav-number.empty-number {
    background-color: #6c757d;
}

.nav-number.current {
    background-color: #2196f3;
    transform: scale(1.1);
    box-shadow: 0 0 0 3px rgba(33, 150, 243, 0.3);
}

.validation-number {
    background-color: #17a2b8;
}

.nav-title {
    font-weight: 500;
    color: #333;
}

.nav-status {
    font-size: 11px;
}

.sticky-top {
    position: sticky;
    top: 20px;
    z-index: 1020;
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);

    // Form validation - hanya validasi URL bukti dan keterangan bukti
    $('form').on('submit', function(e) {
        let isValid = true;
        
        // Check required fields (hanya URL bukti dan keterangan bukti)
        $('input[required], textarea[required]').each(function() {
            if (!$(this).val()) {
                $(this).addClass('is-invalid');
                isValid = false;
            } else {
                $(this).removeClass('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Mohon lengkapi URL bukti dan keterangan bukti.');
        }
    });

    // URL validation
    $('#url_bukti').on('blur', function() {
        const url = $(this).val();
        if (url && !isValidUrl(url)) {
            $(this).addClass('is-invalid');
            if (!$(this).next('.invalid-feedback').length) {
                $(this).after('<div class="invalid-feedback">Format URL tidak valid</div>');
            }
        } else {
            $(this).removeClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
        }
    });

    function isValidUrl(string) {
        try {
            new URL(string);
            return true;
        } catch (_) {
            return false;
        }
    }
    
});
</script>
@endpush