@extends('layouts.app')

@section('title', 'Isi Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('guru.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Isi</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-edit"></i> Isi Instrumen Penilaian
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('guru.instrumen.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    @if($penilaianGuru->count() > 0)
                        <!-- Available Instruments -->
                        <div class="row">
                            @foreach($penilaianGuru as $penilaian)
                            <div class="col-md-6 mb-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">
                                            {{ $penilaian->distribusiInstrumen->instrumen->judul }}
                                        </h5>
                                        <div class="card-tools">
                                            @switch($penilaian->status)
                                                @case('draft')
                                                    <span class="badge badge-secondary">
                                                        <i class="fas fa-clock"></i> Belum Dikerjakan
                                                    </span>
                                                    @break
                                                @case('revision')
                                                    <span class="badge badge-info">
                                                        <i class="fas fa-edit"></i> Perlu Revisi
                                                    </span>
                                                    @break
                                            @endswitch
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>Tahun Ajaran:</strong> {{ $penilaian->distribusiInstrumen->instrumen->tahun_ajaran }}</p>
                                        <p><strong>Semester:</strong> {{ $penilaian->distribusiInstrumen->instrumen->semester }}</p>
                                        <p><strong>Deadline:</strong> {{ $penilaian->distribusiInstrumen->deadline->format('d F Y') }}</p>
                                        <p><strong>Deskripsi:</strong> {{ $penilaian->distribusiInstrumen->instrumen->deskripsi }}</p>
                                        
                                        @if($penilaian->status == 'revision' && $penilaian->catatan_kepala)
                                        <div class="alert alert-warning">
                                            <strong>Catatan dari Kepala:</strong><br>
                                            {{ $penilaian->catatan_kepala }}
                                        </div>
                                        @endif

                                        <div class="mt-3">
                                            <a href="{{ route('guru.instrumen.struktur', $penilaian->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-list-alt"></i> Lihat Struktur
                                            </a>
                                            <a href="{{ route('guru.instrumen.show', $penilaian->id) }}" class="btn btn-primary">
                                                <i class="fas fa-edit"></i> 
                                                @if($penilaian->status == 'revision')
                                                    Perbaiki Instrumen
                                                @else
                                                    Isi Instrumen
                                                @endif
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    @else
                        <!-- No Instruments Available -->
                        <div class="text-center py-5">
                            <i class="fas fa-clipboard-list fa-4x text-muted mb-4"></i>
                            <h4 class="text-muted">Tidak ada instrumen yang perlu diisi</h4>
                            <p class="text-muted">
                                Saat ini tidak ada instrumen penilaian yang perlu Anda isi atau perbaiki.
                            </p>
                            <a href="{{ route('guru.instrumen.index') }}" class="btn btn-primary">
                                <i class="fas fa-arrow-left"></i> Kembali ke Daftar Instrumen
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush