@extends('layouts.app')

@section('title', 'Instrumen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('guru.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-clipboard-list"></i> Instrumen Penilaian
        </h3>
        <div class="card-tools">
            <a href="{{ route('guru.instrumen.isi') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-edit"></i> Isi Instrumen
            </a>
        </div>
    </div>
    <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_instrumen'] }}</h3>
                                    <p>Total Instrumen</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['penilaian_by_status']['draft'] }}</h3>
                                    <p>Belum Dikerjakan</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['penilaian_by_status']['submitted'] }}</h3>
                                    <p>Sudah Disubmit</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{ $stats['penilaian_by_status']['validated'] }}</h3>
                                    <p>Sudah Divalidasi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-star"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-dark">
                                <div class="inner">
                                    <h3>{{ $stats['penilaian_by_status']['final'] }}</h3>
                                    <p>Sudah Final</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-flag-checkered"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Instruments Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Instrumen</th>
                                    <th>Tahun Ajaran</th>
                                    <th>Semester</th>
                                    <th>Deadline</th>
                                    <th>Status</th>
                                    <th>Nilai</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($penilaianGuru as $penilaian)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <strong>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</strong>
                                        <br><small class="text-muted">{{ Str::limit($penilaian->distribusiInstrumen->instrumen->deskripsi, 50) }}</small>
                                        @if($penilaian->distribusiInstrumen->komponen)
                                            <br><span class="badge badge-info">
                                                <i class="fas fa-puzzle-piece"></i> {{ $penilaian->distribusiInstrumen->komponen->nama_komponen }}
                                            </span>
                                        @else
                                            <br><span class="badge badge-success">
                                                <i class="fas fa-check-circle"></i> Semua Komponen
                                            </span>
                                        @endif
                                    </td>
                                    <td>{{ $penilaian->distribusiInstrumen->instrumen->tahun_ajaran }}</td>
                                    <td>Semester {{ $penilaian->distribusiInstrumen->instrumen->semester }}</td>
                                    <td>{{ $penilaian->distribusiInstrumen->deadline->format('d/m/Y') }}</td>
                                    <td>
                                        @php
                                            // Check if all items are completed
                                            $allItems = collect();
                                            foreach ($penilaian->distribusiInstrumen->instrumen->komponenPenilaians as $komponen) {
                                                foreach ($komponen->instrumenPenilaians as $item) {
                                                    $allItems->push($item->id);
                                                }
                                            }
                                            
                                            $jawabanByItem = $penilaian->jawabanGuru->keyBy('instrumen_item_id');
                                            $completedItems = 0;
                                            foreach($allItems as $itemId) {
                                                $jawaban = $jawabanByItem->get($itemId);
                                                $isComplete = $jawaban && $jawaban->url_bukti && $jawaban->keterangan_bukti && $jawaban->nilai_guru_self;
                                                if ($isComplete) $completedItems++;
                                            }
                                            
                                            $isAllCompleted = $completedItems == $allItems->count();
                                            $hasPartialWork = $penilaian->jawabanGuru->count() > 0;
                                        @endphp
                                        
                                        @switch($penilaian->status)
                                            @case('draft')
                                                @if($isAllCompleted)
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle"></i> Siap Submit
                                                    </span>
                                                    <br><small class="text-muted">Semua item lengkap</small>
                                                @elseif($hasPartialWork)
                                                    <span class="badge badge-warning">
                                                        <i class="fas fa-clock"></i> Sedang Dikerjakan
                                                    </span>
                                                    <br><small class="text-muted">{{ $completedItems }}/{{ $allItems->count() }} item</small>
                                                @else
                                                    <span class="badge badge-secondary">
                                                        <i class="fas fa-clock"></i> Draft
                                                    </span>
                                                    <br><small class="text-muted">Belum dikerjakan</small>
                                                @endif
                                                @break
                                            @case('submitted')
                                                <span class="badge badge-warning">
                                                    <i class="fas fa-paper-plane"></i> Submitted
                                                </span>
                                                <br><small class="text-muted">Menunggu review</small>
                                                @break
                                            @case('revision')
                                                <span class="badge badge-info">
                                                    <i class="fas fa-edit"></i> Perlu Revisi
                                                </span>
                                                <br><small class="text-muted">Perlu diperbaiki</small>
                                                @break
                                            @case('validated')
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Validated
                                                </span>
                                                <br><small class="text-muted">Sudah divalidasi</small>
                                                @break
                                            @case('final')
                                                <span class="badge badge-primary">
                                                    <i class="fas fa-flag-checkered"></i> Final
                                                </span>
                                                <br><small class="text-muted">Sudah disubmit ke pengawas</small>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>
                                        @if($penilaian->rata_rata)
                                            <strong>{{ number_format($penilaian->rata_rata, 2) }}</strong>
                                            @if($penilaian->total_nilai)
                                                <br><small class="text-muted">Total: {{ number_format($penilaian->total_nilai, 2) }}</small>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if(in_array($penilaian->status, ['draft', 'revision']))
                                            <a href="{{ route('guru.instrumen.show', $penilaian->id) }}" class="btn btn-primary btn-sm" title="Isi Instrumen">
                                                <i class="fas fa-edit"></i> Isi
                                            </a>
                                        @elseif($penilaian->status == 'submitted')
                                            <span class="badge badge-info">Menunggu Review</span>
                                        @else
                                            <a href="{{ route('guru.hasil.show', $penilaian->id) }}" class="btn btn-info btn-sm" title="Lihat Hasil">
                                                <i class="fas fa-eye"></i> Lihat
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada instrumen</h5>
                                            <p class="text-muted">Belum ada instrumen penilaian yang didistribusikan ke lembaga Anda.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush