@extends('layouts.app')

@section('title', 'Detail Hasil Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('guru.hasil.index') }}">Hasil</a></li>
<li class="breadcrumb-item active">Detail</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-eye"></i> Detail Hasil Penilaian
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('guru.hasil.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Instrument Information -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Informasi Instrumen</h5>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-4">Judul:</dt>
                                        <dd class="col-sm-8">{{ $penilaianGuru->distribusiInstrumen->instrumen->judul }}</dd>
                                        
                                        <dt class="col-sm-4">Tahun Ajaran:</dt>
                                        <dd class="col-sm-8">{{ $penilaianGuru->distribusiInstrumen->instrumen->tahun_ajaran }}</dd>
                                        
                                        <dt class="col-sm-4">Semester:</dt>
                                        <dd class="col-sm-8">Semester {{ $penilaianGuru->distribusiInstrumen->instrumen->semester }}</dd>
                                        
                                        <dt class="col-sm-4">Deadline:</dt>
                                        <dd class="col-sm-8">{{ $penilaianGuru->distribusiInstrumen->deadline->format('d F Y') }}</dd>
                                        
                                        <dt class="col-sm-4">Status:</dt>
                                        <dd class="col-sm-8">
                                            @switch($penilaianGuru->status)
                                                @case('draft')
                                                    <span class="badge badge-secondary">Draft</span>
                                                    @break
                                                @case('submitted')
                                                    <span class="badge badge-warning">Submitted</span>
                                                    @break
                                                @case('revision')
                                                    <span class="badge badge-info">Perlu Revisi</span>
                                                    @break
                                                @case('validated')
                                                    <span class="badge badge-success">Validated</span>
                                                    @break
                                            @endswitch
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Hasil Penilaian</h5>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-4">Tanggal Submit:</dt>
                                        <dd class="col-sm-8">
                                            @if($penilaianGuru->tanggal_submit)
                                                {{ $penilaianGuru->tanggal_submit->format('d F Y H:i') }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </dd>
                                        
                                        <dt class="col-sm-4">Tanggal Validasi:</dt>
                                        <dd class="col-sm-8">
                                            @if($penilaianGuru->tanggal_validasi)
                                                {{ $penilaianGuru->tanggal_validasi->format('d F Y H:i') }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </dd>
                                        
                                        <dt class="col-sm-4">Total Nilai:</dt>
                                        <dd class="col-sm-8">
                                            @if($penilaianGuru->total_nilai)
                                                <strong>{{ number_format($penilaianGuru->total_nilai, 2) }}</strong>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </dd>
                                        
                                        <dt class="col-sm-4">Rata-rata:</dt>
                                        <dd class="col-sm-8">
                                            @if($penilaianGuru->rata_rata)
                                                <strong>{{ number_format($penilaianGuru->rata_rata, 2) }}</strong>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </dd>
                                        
                                        @if($penilaianGuru->catatan_kepala)
                                        <dt class="col-sm-4">Catatan:</dt>
                                        <dd class="col-sm-8">{{ $penilaianGuru->catatan_kepala }}</dd>
                                        @endif
                                    </dl>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Assessment Details -->
                    @if($penilaianGuru->jawabanGuru->count() > 0)
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">Detail Penilaian</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th width="20%">Indikator</th>
                                            <th width="15%">Evidensi</th>
                                            <th width="25%">Bukti URL</th>
                                            <th width="15%">Nilai Guru</th>
                                            <th width="15%">Nilai Kepala</th>
                                            <th width="25%">Catatan Kepala</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($penilaianGuru->jawabanGuru as $jawaban)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>
                                                <strong>{{ $jawaban->instrumenItem->aspek_dimensi ?? '-' }}</strong>
                                                @if($jawaban->instrumenItem->indikator)
                                                    <br><small class="text-muted">{{ $jawaban->instrumenItem->indikator }}</small>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban->instrumenItem->bukti_yang_diperlukan)
                                                    {{ Str::limit($jawaban->instrumenItem->bukti_yang_diperlukan, 50) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban->url_bukti)
                                                    <a href="{{ $jawaban->url_bukti }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-external-link-alt"></i> Lihat Bukti
                                                    </a>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban->nilai_guru_self)
                                                    <span class="badge badge-info">{{ $jawaban->nilai_guru_self }}</span>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban->nilai_kepala)
                                                    <span class="badge badge-success">{{ $jawaban->nilai_kepala }}</span>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($jawaban->catatan_kepala)
                                                    {{ $jawaban->catatan_kepala }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @else
                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> Belum Ada Detail Penilaian</h5>
                        <p class="mb-0">Detail penilaian belum tersedia atau belum diisi.</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
