@extends('layouts.app')

@section('title', 'Hasil Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('guru.hasil.index') }}">Hasil</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-bar"></i> Hasil Penilaian
                    </h3>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_penilaian'] }}</h3>
                                    <p>Total Penilaian</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['penilaian_by_status']['submitted'] }}</h3>
                                    <p>Menunggu Review</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['penilaian_by_status']['validated'] }}</h3>
                                    <p>Sudah Divalidasi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{ number_format($stats['rata_rata_nilai'], 2) }}</h3>
                                    <p>Rata-rata Nilai</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-star"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Results Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Instrumen</th>
                                    <th>Tahun Ajaran</th>
                                    <th>Semester</th>
                                    <th>Status</th>
                                    <th>Tanggal Submit</th>
                                    <th>Nilai</th>
                                    <th>Catatan</th>
                                    <th width="10%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($penilaianGuru as $penilaian)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <strong>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</strong>
                                        <br><small class="text-muted">{{ Str::limit($penilaian->distribusiInstrumen->instrumen->deskripsi, 50) }}</small>
                                    </td>
                                    <td>{{ $penilaian->distribusiInstrumen->instrumen->tahun_ajaran }}</td>
                                    <td>Semester {{ $penilaian->distribusiInstrumen->instrumen->semester }}</td>
                                    <td>
                                        @switch($penilaian->status)
                                            @case('draft')
                                                <span class="badge badge-secondary">
                                                    <i class="fas fa-clock"></i> Draft
                                                </span>
                                                @break
                                            @case('submitted')
                                                <span class="badge badge-warning">
                                                    <i class="fas fa-paper-plane"></i> Submitted
                                                </span>
                                                @break
                                            @case('revision')
                                                <span class="badge badge-info">
                                                    <i class="fas fa-edit"></i> Perlu Revisi
                                                </span>
                                                @break
                                            @case('validated')
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Validated
                                                </span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>
                                        @if($penilaian->tanggal_submit)
                                            {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->rata_rata)
                                            <strong>{{ number_format($penilaian->rata_rata, 2) }}</strong>
                                            @if($penilaian->total_nilai)
                                                <br><small class="text-muted">Total: {{ number_format($penilaian->total_nilai, 2) }}</small>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->catatan_kepala)
                                            <span title="{{ $penilaian->catatan_kepala }}">
                                                {{ Str::limit($penilaian->catatan_kepala, 30) }}
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('guru.hasil.show', $penilaian->id) }}" class="btn btn-info btn-sm" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-chart-bar fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada hasil penilaian</h5>
                                            <p class="text-muted">Belum ada penilaian yang telah diselesaikan.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush