@extends('layouts.app')

@section('title', 'Dashboard Guru')

@section('breadcrumb')
<li class="breadcrumb-item active">Dashboard</li>
@endsection

@section('content')
<!-- Info boxes -->
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info elevation-1"><i class="fas fa-clipboard-list"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Instrumen Tersedia</span>
                <span class="info-box-number">{{ \App\Models\PenilaianGuru::where('guru_id', Auth::user()->guru->id ?? 0)->whereHas('distribusiInstrumen', function($q) { $q->where('status', 'active'); })->count() }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-edit"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Sedang Dikerjakan</span>
                <span class="info-box-number">{{ \App\Models\PenilaianGuru::where('guru_id', Auth::user()->guru->id ?? 0)->where('status', 'draft')->count() }}</span>
            </div>
        </div>
    </div>
    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-check"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Sudah Disubmit</span>
                <span class="info-box-number">{{ \App\Models\PenilaianGuru::where('guru_id', Auth::user()->guru->id ?? 0)->whereIn('status', ['submitted', 'validated'])->count() }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-star"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Rata-rata Nilai</span>
                <span class="info-box-number">{{ number_format(\App\Models\PenilaianGuru::where('guru_id', Auth::user()->guru->id ?? 0)->where('status', 'validated')->avg('rata_rata') ?? 0, 2) }}</span>
            </div>
        </div>
    </div>
</div>

<!-- Main row -->
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Instrumen Penilaian</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Instrumen</th>
                                <th>Tahun Ajaran</th>
                                <th>Semester</th>
                                <th>Deadline</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse(\App\Models\PenilaianGuru::where('guru_id', Auth::user()->guru->id ?? 0)->with('distribusiInstrumen.instrumen')->take(5)->get() as $penilaian)
                            <tr>
                                <td>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</td>
                                <td>{{ $penilaian->distribusiInstrumen->instrumen->tahun_ajaran }}</td>
                                <td>{{ $penilaian->distribusiInstrumen->instrumen->semester }}</td>
                                <td>{{ \Carbon\Carbon::parse($penilaian->distribusiInstrumen->deadline)->format('d/m/Y') }}</td>
                                <td>
                                    <span class="badge badge-{{ $penilaian->status == 'validated' ? 'success' : ($penilaian->status == 'submitted' ? 'warning' : 'info') }}">
                                        {{ ucfirst($penilaian->status) }}
                                    </span>
                                </td>
                                <td>
                                    @if($penilaian->status == 'draft')
                                        <a href="#" class="btn btn-sm btn-primary">Lanjutkan</a>
                                    @elseif($penilaian->status == 'submitted')
                                        <span class="text-muted">Menunggu Review</span>
                                    @elseif($penilaian->status == 'validated')
                                        <a href="#" class="btn btn-sm btn-success">Lihat Hasil</a>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">Belum ada instrumen penilaian</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Profil Singkat</h3>
            </div>
            <div class="card-body">
                @if(Auth::user()->guru)
                <div class="text-center">
                    <img src="https://adminlte.io/themes/v3/dist/img/user2-160x160.jpg" class="img-circle elevation-2 mb-3" alt="User Image" style="width: 80px; height: 80px;">
                    <h5>{{ Auth::user()->guru->nama_lengkap_with_gelar }}</h5>
                    <p class="text-muted">{{ Auth::user()->guru->mata_pelajaran }}</p>
                    <p class="text-muted">{{ Auth::user()->guru->kelas_diampu }}</p>
                </div>
                <hr>
                <div class="row text-center">
                    <div class="col-6">
                        <h4>{{ Auth::user()->guru->status_kepegawaian }}</h4>
                        <small class="text-muted">Status Kepegawaian</small>
                    </div>
                    <div class="col-6">
                        <h4>{{ ucfirst(Auth::user()->guru->status_sertifikasi) }}</h4>
                        <small class="text-muted">Status Sertifikasi</small>
                    </div>
                </div>
                @else
                <div class="text-center text-muted">
                    <p>Profil guru belum lengkap</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection