@extends('layouts.app')

@section('title', 'Dokumentasi')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="jumbotron p-4 bg-white border rounded shadow-sm">
                <h2 class="mb-2"><i class="fas fa-book-open text-primary mr-2"></i> Dokumentasi Penggunaan Aplikasi</h2>
                <p class="text-muted mb-0">
                    Panduan singkat dan runtut untuk peran <strong>{{ ucfirst($role) }}</strong> agar dapat menggunakan aplikasi ini dengan lancar.
                </p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white"><strong>Alur Utama</strong></div>
                <div class="card-body">
                    <ol class="mb-0">
                        @if($role === 'pengawas')
                            <li class="mb-3"><strong>Masuk ke Dashboard Pengawas</strong> untuk melihat ringkasan distribusi dan status penilaian.</li>
                            <li class="mb-3"><strong>Kelola Lembaga</strong> di menu Lembaga: tambah/claim lembaga binaan, periksa profil lembaga.</li>
                            <li class="mb-3"><strong>Distribusikan Instrumen</strong> ke lembaga/kepala: pilih instrumen aktif dan tetapkan jadwal.</li>
                            <li class="mb-3"><strong>Nilai Kepala</strong> di menu Penilaian: tinjau jawaban & bukti yang diunggah kepala, beri skor setiap indikator sesuai rubrik, dan tambahkan catatan/umpan balik. <em>(Opsional) unggah bukti pendukung penilaian bila diperlukan.</em></li>
                            <li class="mb-3"><strong>Finalisasi & Raport</strong>: simpan, periksa kembali, lalu generate raport untuk dibagikan.</li>
                        @else
                            <li class="mb-3"><strong>Masuk ke Dashboard Kepala</strong> untuk melihat penugasan dan status instrumen.</li>
                            <li class="mb-3"><strong>Lengkapi Profil Lembaga</strong> di menu Lembaga: pastikan data identitas & kontak akurat.</li>
                            <li class="mb-3"><strong>Isi Instrumen</strong> pada menu Instrumen: jawab indikator dan unggah bukti pendukung (file atau tautan). Jika menggunakan tautan cloud (mis. Google Drive/OneDrive), pastikan akses disetel <em>siapa saja yang memiliki tautan</em> minimal <strong>dapat melihat</strong>.</li>
                            <li class="mb-3"><strong>Periksa Catatan</strong> dari pengawas pada notifikasi & halaman penilaian.</li>
                            <li class="mb-3"><strong>Unduh Raport</strong> setelah penilaian selesai sebagai bahan refleksi & tindak lanjut.</li>
                        @endif
                    </ol>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <strong>
                        @if($role === 'pengawas')
                            Tips Penilaian yang Baik
                        @else
                            Tips Pengisian yang Baik
                        @endif
                    </strong>
                </div>
                <div class="card-body">
                    <ul class="mb-0">
                        @if($role === 'pengawas')
                            <li class="mb-2">Tinjau <strong>bukti yang spesifik & relevan</strong> dari kepala; minta pelengkap bila diperlukan.</li>
                            <li class="mb-2">Beri <strong>catatan yang jelas dan konstruktif</strong> untuk tiap indikator.</li>
                            <li class="mb-2">Beri skor sesuai <strong>rubrik</strong> dan jaga konsistensi antar lembaga.</li>
                            <li class="mb-2">Simpan progres penilaian secara berkala dan gunakan <strong>pencarian/filter</strong> untuk navigasi cepat.</li>
                            <li class="mb-2">(Opsional) Tambahkan bukti pendukung penilaian jika dibutuhkan untuk akuntabilitas.</li>
                        @else
                            <li class="mb-2">Gunakan bukti yang <strong>spesifik & relevan</strong> (SK, foto kegiatan, laporan, tautan cloud yang dapat diakses publik).</li>
                            <li class="mb-2">Berikan <strong>deskripsi singkat</strong> saat mengunggah bukti agar penilai memahami konteks.</li>
                            <li class="mb-2">Simpan pekerjaan secara berkala. Jika sesi berakhir, Anda tidak kehilangan progres.</li>
                            <li class="mb-2">Gunakan <strong>fitur pencarian</strong> di tabel untuk memudahkan navigasi data.</li>
                            <li class="mb-2">Pastikan ukuran file bukti tidak melebihi batas agar unggah berjalan lancar.</li>
                            <li class="mb-2"><strong>Jika bukti berupa tautan</strong>: atur izin berbagi menjadi <em>Anyone with the link can view</em> / <em>Siapa saja yang memiliki tautan dapat melihat</em>, nonaktifkan pembatasan login, dan uji buka tautan di mode incognito.</li>
                            <li class="mb-2">Gunakan format umum untuk dokumen/gambar (PDF, JPG/PNG, DOCX) agar mudah ditinjau.</li>
                        @endif
                    </ul>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header bg-primary text-white"><strong>Tanya Jawab (FAQ)</strong></div>
                <div class="card-body">
                    <div class="accordion" id="faq">
                        <div class="card">
                            <div class="card-header p-2" id="q1">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#a1">Bukti apa yang disarankan?</button>
                            </div>
                            <div id="a1" class="collapse show" data-parent="#faq">
                                <div class="card-body pt-0">Dokumen kebijakan, program kerja, hasil supervisi, foto kegiatan, berita acara, rekaman rapat, dan laporan evaluasi.</div>
                            </div>
                        </div>
                        <div class="card mt-2">
                            <div class="card-header p-2" id="q2">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#a2">Bagaimana jika unggah gagal?</button>
                            </div>
                            <div id="a2" class="collapse" data-parent="#faq">
                                <div class="card-body pt-0">Periksa ukuran/format file, koneksi internet, dan coba ulang. Jika masih gagal, hubungi admin.</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white"><strong>Ringkasan Peran</strong></div>
                <div class="card-body">
                    @if($role === 'pengawas')
                        <p class="mb-2"><i class="fas fa-user-check text-primary mr-1"></i> Pengawas memfasilitasi, menilai, dan membimbing kepala.</p>
                        <p class="mb-2">Fokus pada objektivitas penilaian dan kejelasan catatan.</p>
                    @else
                        <p class="mb-2"><i class="fas fa-user-tie text-primary mr-1"></i> Kepala mengisi instrumen, unggah bukti, dan menindaklanjuti umpan balik.</p>
                        <p class="mb-2">Fokus pada perbaikan berkelanjutan dan layanan peserta didik.</p>
                    @endif
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-primary text-white"><strong>Kontak Bantuan</strong></div>
                <div class="card-body">
                    <p class="mb-1"><i class="fas fa-envelope mr-2"></i> Email: {{ config('mail.from.address', 'support@example.com') }}</p>
                    <p class="mb-0"><i class="fas fa-globe mr-2"></i> Website: {{ \App\Helpers\AppHelper::getAppName() }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


