@extends('layouts.app')

@section('title', 'Detail User')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">Users</a></li>
<li class="breadcrumb-item active">Detail</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-user"></i> Detail User: {{ $user->name }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-warning btn-sm">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('admin.users.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3">
                <div class="text-center">
                    <img src="https://adminlte.io/themes/v3/dist/img/user2-160x160.jpg" class="img-circle elevation-2 mb-3" alt="User Image" style="width: 120px; height: 120px;">
                    <h4>{{ $user->name }}</h4>
                    <p class="text-muted">
                        @foreach($user->roles as $role)
                            <span class="badge badge-{{ $role->name == 'admin' ? 'danger' : ($role->name == 'pengawas' ? 'info' : ($role->name == 'kepala' ? 'success' : 'warning')) }}">
                                {{ ucfirst($role->name) }}
                            </span>
                        @endforeach
                    </p>
                </div>
            </div>
            <div class="col-md-9">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-box bg-info">
                            <span class="info-box-icon"><i class="fas fa-envelope"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Email</span>
                                <span class="info-box-number">{{ $user->email }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-box bg-success">
                            <span class="info-box-icon"><i class="fas fa-phone"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Telepon</span>
                                <span class="info-box-number">{{ $user->phone ?? 'Tidak ada' }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-box bg-warning">
                            <span class="info-box-icon"><i class="fas fa-calendar"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Tanggal Dibuat</span>
                                <span class="info-box-number">{{ $user->created_at->format('d/m/Y H:i') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-box bg-danger">
                            <span class="info-box-icon"><i class="fas fa-{{ $user->is_active ? 'check' : 'ban' }}"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Status</span>
                                <span class="info-box-number">{{ $user->is_active ? 'Aktif' : 'Nonaktif' }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Removed: Informasi Guru section -->

                @if($user->hasRole('pengawas'))
                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Lembaga Binaan ({{ $user->lembaga()->count() }})</h3>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Nama Lembaga</th>
                                        <th>Jenis</th>
                                        <th>NPSN/NSM</th>
                                        <th>Kepala</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($user->lembaga()->take(5)->get() as $lembaga)
                                    <tr>
                                        <td>{{ $lembaga->nama_lembaga }}</td>
                                        <td><span class="badge badge-info">{{ $lembaga->jenis }}</span></td>
                                        <td>{{ $lembaga->npsn_nsm }}</td>
                                        <td>{{ $lembaga->nama_kepala }}</td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="4" class="text-center">Belum ada lembaga binaan</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
