@extends('layouts.app')

@section('title', 'Manajemen Users')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">Users</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<!-- Statistics Cards -->
<div class="row mb-3">
    <div class="col-lg-3 col-6">
        <div class="small-box bg-info">
            <div class="inner">
                <h3>{{ $stats['total'] }}</h3>
                <p>Total Users</p>
            </div>
            <div class="icon">
                <i class="fas fa-users"></i>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box bg-success">
            <div class="inner">
                <h3>{{ $stats['active'] }}</h3>
                <p>Users Aktif</p>
            </div>
            <div class="icon">
                <i class="fas fa-user-check"></i>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box bg-warning">
            <div class="inner">
                <h3>{{ $stats['inactive'] }}</h3>
                <p>Users Nonaktif</p>
            </div>
            <div class="icon">
                <i class="fas fa-user-times"></i>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box bg-danger">
            <div class="inner">
                <h3>{{ $stats['new_today'] }}</h3>
                <p>Baru Hari Ini</p>
            </div>
            <div class="icon">
                <i class="fas fa-user-plus"></i>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-users"></i> Manajemen Users
        </h3>
        <div class="card-tools">
            <div class="btn-group">
                <button type="button" class="btn btn-warning btn-sm" onclick="bulkAction('activate')" disabled>
                    <i class="fas fa-check"></i> Aktifkan
                </button>
                <button type="button" class="btn btn-secondary btn-sm" onclick="bulkAction('deactivate')" disabled>
                    <i class="fas fa-ban"></i> Nonaktifkan
                </button>
                <button type="button" class="btn btn-danger btn-sm" onclick="bulkAction('delete')" disabled>
                    <i class="fas fa-trash"></i> Hapus
                </button>
            </div>
            <div class="btn-group ml-2">
                <button type="button" class="btn btn-success btn-sm" onclick="exportData()">
                    <i class="fas fa-download"></i> Export
                </button>
                <a href="{{ route('admin.users.download-template') }}" class="btn btn-info btn-sm" onclick="downloadTemplate(event)">
                    <i class="fas fa-file-excel"></i> Template
                </a>
                <button type="button" class="btn btn-warning btn-sm" onclick="openImportModal()">
                    <i class="fas fa-upload"></i> Import
                </button>
            </div>
            <a href="{{ route('admin.users.create') }}" class="btn btn-primary btn-sm ml-2">
                <i class="fas fa-plus"></i> Tambah User
            </a>
        </div>
    </div>
    <div class="card-body">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Advanced Filter Form -->
        <div class="row mb-3">
            <div class="col-md-12">
                <form method="GET" action="{{ route('admin.users.index') }}" class="form-inline">
                    <div class="form-group mr-2">
                        <select name="role" class="form-control form-control-sm">
                            <option value="">Semua Role</option>
                            <option value="admin" {{ request('role') == 'admin' ? 'selected' : '' }}>Admin</option>
                            <option value="pengawas" {{ request('role') == 'pengawas' ? 'selected' : '' }}>Pengawas</option>
                            <option value="kepala" {{ request('role') == 'kepala' ? 'selected' : '' }}>Kepala</option>
                            <option value="guru" {{ request('role') == 'guru' ? 'selected' : '' }}>Guru</option>
                        </select>
                    </div>
                    <div class="form-group mr-2">
                        <select name="status" class="form-control form-control-sm">
                            <option value="">Semua Status</option>
                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Aktif</option>
                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Nonaktif</option>
                        </select>
                    </div>
                    <div class="form-group mr-2">
                        <input type="date" name="date_from" class="form-control form-control-sm" placeholder="Dari Tanggal" value="{{ request('date_from') }}">
                    </div>
                    <div class="form-group mr-2">
                        <input type="date" name="date_to" class="form-control form-control-sm" placeholder="Sampai Tanggal" value="{{ request('date_to') }}">
                    </div>
                    <div class="form-group mr-2">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Cari nama, email, atau phone..." value="{{ request('search') }}">
                    </div>
                    <button type="submit" class="btn btn-secondary btn-sm">
                        <i class="fas fa-search"></i> Filter
                    </button>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary btn-sm ml-2">
                        <i class="fas fa-times"></i> Reset
                    </a>
                </form>
            </div>
        </div>

        <div class="table-responsive">
            <form id="bulkForm" action="{{ route('admin.users.bulk-action') }}" method="POST">
                @csrf
                <input type="hidden" name="action" id="bulkActionType">
                <input type="hidden" name="user_ids" id="bulkUserIds">
                
                <table class="table table-striped table-hover" id="usersTable">
                    <thead class="thead-dark">
                        <tr>
                            <th width="3%">
                                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()">
                            </th>
                            <th width="5%">ID</th>
                            <th width="20%">Nama</th>
                            <th width="20%">Email</th>
                            <th width="15%">Role</th>
                            <th width="10%">Status</th>
                            <th width="12%">Tanggal Dibuat</th>
                            <th width="15%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($users as $user)
                        <tr>
                            <td>
                                <input type="checkbox" class="user-checkbox" value="{{ $user->id }}" onchange="updateBulkButtons()">
                            </td>
                            <td>{{ $user->id }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="https://adminlte.io/themes/v3/dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image" style="width: 30px; height: 30px; margin-right: 10px;">
                                    <div>
                                        <strong>{{ $user->name }}</strong>
                                        @if($user->phone)
                                            <br><small class="text-muted">{{ $user->phone }}</small>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>{{ $user->email }}</td>
                            <td>
                                @foreach($user->roles as $role)
                                    <span class="badge badge-{{ $role->name == 'admin' ? 'danger' : ($role->name == 'pengawas' ? 'info' : ($role->name == 'kepala' ? 'success' : 'warning')) }}">
                                        {{ ucfirst($role->name) }}
                                    </span>
                                @endforeach
                            </td>
                            <td>
                                <span class="badge badge-{{ $user->is_active ? 'success' : 'danger' }}">
                                    {{ $user->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span>
                            </td>
                            <td>{{ $user->created_at->format('d/m/Y H:i') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.users.show', $user) }}" class="btn btn-info btn-sm" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.users.toggle-status', $user) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="btn btn-{{ $user->is_active ? 'secondary' : 'success' }} btn-sm" title="{{ $user->is_active ? 'Nonaktifkan' : 'Aktifkan' }}" onclick="return confirm('Apakah Anda yakin?')">
                                            <i class="fas fa-{{ $user->is_active ? 'ban' : 'check' }}"></i>
                                        </button>
                                    </form>
                                    @if($user->roles->count() > 0 && !$user->hasRole('admin'))
                                    <form action="{{ route('admin.users.destroy', $user) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus user ini?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Tidak ada data user</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </form>
        </div>

        <div class="d-flex justify-content-center mt-3">
            {{ $users->appends(request()->query())->links('pagination::bootstrap-4-custom') }}
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Hide duplicate pagination if any */
    .card-body > .d-flex:not(:last-child) nav,
    .card-body > nav:not(:last-of-type) {
        display: none !important;
    }
    
    /* Fix pagination arrow button sizes - make all buttons consistent */
    .pagination .page-link {
        min-width: 38px;
        text-align: center;
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem !important;
        line-height: 1.5;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Specifically target first and last buttons (prev/next arrows) */
    .pagination .page-item:first-child .page-link,
    .pagination .page-item:last-child .page-link {
        min-width: 38px;
        max-width: 38px;
        font-size: 0.875rem !important;
        padding: 0.5rem 0.5rem;
        font-weight: normal;
    }
    
    /* Ensure all page links have same height */
    .pagination .page-item {
        height: 38px;
    }
    
    .pagination .page-item .page-link {
        height: 38px;
    }
    
    /* Hide duplicate navigation elements */
    .card-body nav ~ nav,
    .d-flex nav ~ nav {
        display: none !important;
    }
</style>
@endpush

<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" role="dialog" aria-labelledby="importModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="importModalLabel">
                    <i class="fas fa-upload"></i> Import Users dari Excel
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <h6><i class="fas fa-info-circle"></i> Petunjuk Import:</h6>
                    <ul class="mb-0 small">
                        <li>Download template Excel terlebih dahulu untuk melihat format yang benar</li>
                        <li>File harus berformat .xlsx, .xls, atau .csv</li>
                        <li>Maksimal ukuran file: 2MB</li>
                        <li>Kolom yang wajib diisi: <strong>Nama Lengkap, Email</strong></li>
                        <li>Password akan otomatis "password123" jika tidak diisi</li>
                        <li>Role yang valid: admin, pengawas, kepala, guru (case-insensitive)</li>
                        <li>Status yang valid: Aktif, Nonaktif (case-insensitive)</li>
                        <li>Email yang sudah ada akan dilewati</li>
                    </ul>
                </div>

                <form id="importForm" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="importFile">Pilih File Excel</label>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="importFile" name="file" accept=".xlsx,.xls,.csv" required>
                                <label class="custom-file-label" for="importFile">Choose file</label>
                            </div>
                        </div>
                        <small class="form-text text-muted">Format yang didukung: .xlsx, .xls, .csv (Maksimal 2MB)</small>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Kolom</th>
                                            <th>Wajib</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Nama Lengkap</td>
                                            <td><span class="badge badge-danger">Ya</span></td>
                                        </tr>
                                        <tr>
                                            <td>Email</td>
                                            <td><span class="badge badge-danger">Ya</span></td>
                                        </tr>
                                        <tr>
                                            <td>Phone</td>
                                            <td><span class="badge badge-secondary">Tidak</span></td>
                                        </tr>
                                        <tr>
                                            <td>Password</td>
                                            <td><span class="badge badge-secondary">Tidak</span></td>
                                        </tr>
                                        <tr>
                                            <td>Role</td>
                                            <td><span class="badge badge-secondary">Tidak</span></td>
                                        </tr>
                                        <tr>
                                            <td>Status</td>
                                            <td><span class="badge badge-secondary">Tidak</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h6><strong>Contoh Data:</strong></h6>
                            <div class="bg-light p-3 rounded">
                                <small>
                                    <strong>Nama Lengkap:</strong> John Doe<br>
                                    <strong>Email:</strong> john@example.com<br>
                                    <strong>Phone:</strong> 081234567890<br>
                                    <strong>Password:</strong> password123<br>
                                    <strong>Role:</strong> guru, Pengawas, ADMIN<br>
                                    <strong>Status:</strong> Aktif, AKTIF, aktif
                                </small>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i> Batal
                </button>
                <button type="button" class="btn btn-info" onclick="downloadTemplateModal()">
                    <i class="fas fa-file-excel"></i> Download Template
                </button>
                <button type="button" class="btn btn-primary" onclick="submitImportModal()">
                    <i class="fas fa-upload"></i> Import Users
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Select All functionality
function toggleSelectAll() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.user-checkbox');
    
    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAll.checked;
    });
    
    updateBulkButtons();
}

// Update bulk action buttons (only for bulk actions, not utility buttons)
function updateBulkButtons() {
    const checkedBoxes = document.querySelectorAll('.user-checkbox:checked');
    // Only target bulk action buttons (Aktifkan, Nonaktifkan, Hapus) in the first btn-group
    const bulkButtons = document.querySelectorAll('.card-tools .btn-group:first-child button');
    
    if (checkedBoxes.length > 0) {
        bulkButtons.forEach(btn => {
            btn.disabled = false;
            btn.classList.remove('disabled');
        });
    } else {
        bulkButtons.forEach(btn => {
            btn.disabled = true;
            btn.classList.add('disabled');
        });
    }
}

// Bulk action handler
function bulkAction(action) {
    const checkedBoxes = document.querySelectorAll('.user-checkbox:checked');
    
    if (checkedBoxes.length === 0) {
        alert('Pilih minimal satu user untuk melakukan aksi ini!');
        return;
    }
    
    const actionText = {
        'activate': 'mengaktifkan',
        'deactivate': 'menonaktifkan',
        'delete': 'menghapus'
    };
    
    const confirmed = confirm(`Apakah Anda yakin ingin ${actionText[action]} ${checkedBoxes.length} user?`);
    
    if (confirmed) {
        const userIds = Array.from(checkedBoxes).map(cb => cb.value);
        
        document.getElementById('bulkActionType').value = action;
        document.getElementById('bulkUserIds').value = JSON.stringify(userIds);
        document.getElementById('bulkForm').submit();
    }
}

// Export data
function exportData() {
    const form = document.querySelector('form[method="GET"]');
    const formData = new FormData(form);
    
    // Build URL with current filters
    const params = new URLSearchParams();
    for (let [key, value] of formData.entries()) {
        if (value) params.append(key, value);
    }
    
    // Download Excel file
    window.location.href = '{{ route("admin.users.export") }}?' + params.toString();
}

// Download template with fallback
function downloadTemplate(event) {
    event.preventDefault();
    
    // Try admin route first
    fetch('{{ route("admin.users.download-template") }}')
        .then(response => {
            if (response.ok) {
                // If successful, trigger download
                window.location.href = '{{ route("admin.users.download-template") }}';
            } else {
                // If failed, use public route as fallback
                console.log('Admin route failed, using public route');
                window.location.href = '{{ route("public.users.template") }}';
            }
        })
        .catch(error => {
            console.log('Error with admin route, using public route:', error);
            window.location.href = '{{ route("public.users.template") }}';
        });
}

// Open import modal (independent of bulk actions)
function openImportModal() {
    $('#importModal').modal('show');
}

// Download template from modal
function downloadTemplateModal() {
    // Try admin route first
    fetch('{{ route("admin.users.download-template") }}')
        .then(response => {
            if (response.ok) {
                // If successful, trigger download
                window.location.href = '{{ route("admin.users.download-template") }}';
            } else {
                // If failed, use public route as fallback
                console.log('Admin route failed, using public route');
                window.location.href = '{{ route("public.users.template") }}';
            }
        })
        .catch(error => {
            console.log('Error with admin route, using public route:', error);
            window.location.href = '{{ route("public.users.template") }}';
        });
}

// Submit import from modal
function submitImportModal() {
    const form = document.getElementById('importForm');
    const fileInput = document.getElementById('importFile');
    
    // Check if file is selected
    if (!fileInput.files.length) {
        alert('Pilih file Excel terlebih dahulu!');
        return;
    }
    
    // Check file size (2MB limit)
    const file = fileInput.files[0];
    if (file.size > 2 * 1024 * 1024) {
        alert('Ukuran file maksimal 2MB!');
        return;
    }
    
    // Check file type
    const allowedTypes = ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                         'application/vnd.ms-excel', 'text/csv'];
    if (!allowedTypes.includes(file.type)) {
        alert('Format file harus .xlsx, .xls, atau .csv!');
        return;
    }
    
    // Show loading
    const submitBtn = event.target;
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Mengimport...';
    submitBtn.disabled = true;
    
    // Try admin route first
    fetch('{{ route("admin.users.import") }}', {
        method: 'POST',
        body: new FormData(form),
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        if (response.ok) {
            // If successful, submit to admin route
            form.action = '{{ route("admin.users.import") }}';
            form.submit();
        } else {
            // If failed, use public route as fallback
            console.log('Admin route failed, using public route');
            form.action = '{{ route("public.users.import.store") }}';
            form.submit();
        }
    })
    .catch(error => {
        console.log('Error with admin route, using public route:', error);
        form.action = '{{ route("public.users.import.store") }}';
        form.submit();
    })
    .finally(() => {
        // Reset button
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

// Update file input label
document.addEventListener('DOMContentLoaded', function() {
    updateBulkButtons();
    
    // File input change handler
    document.getElementById('importFile').addEventListener('change', function(e) {
        const fileName = e.target.files[0]?.name || 'Choose file';
        const label = e.target.nextElementSibling;
        label.textContent = fileName;
    });
});
</script>
@endpush
@endsection
