@extends('layouts.app')

@section('title', 'Import Users')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">Users</a></li>
<li class="breadcrumb-item active">Import</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-upload"></i> Import Users dari Excel
                </h3>
            </div>
            <div class="card-body">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                <div class="alert alert-info">
                    <h5><i class="icon fas fa-info"></i> Petunjuk Import:</h5>
                    <ul class="mb-0">
                        <li>Download template Excel terlebih dahulu untuk melihat format yang benar</li>
                        <li>File harus berformat .xlsx, .xls, atau .csv</li>
                        <li>Maksimal ukuran file: 2MB</li>
                        <li>Kolom yang wajib diisi: Nama Lengkap, Email</li>
                        <li>Password akan otomatis "password123" jika tidak diisi</li>
                        <li>Role yang valid: admin, pengawas, kepala, guru (case-insensitive)</li>
                        <li>Status yang valid: Aktif, Nonaktif (case-insensitive)</li>
                        <li>Email yang sudah ada akan dilewati</li>
                    </ul>
                </div>

                <form id="importForm" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="file">Pilih File Excel</label>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="file" name="file" accept=".xlsx,.xls,.csv" required>
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary" onclick="submitImport(event)">
                            <i class="fas fa-upload"></i> Import Users
                        </button>
                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-download"></i> Template & Panduan
                </h3>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.users.download-template') }}" class="btn btn-info" onclick="downloadTemplate(event)">
                        <i class="fas fa-file-excel"></i> Download Template Excel
                    </a>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-outline-primary">
                        <i class="fas fa-list"></i> Lihat Data Users
                    </a>
                </div>

                <hr>

                <h6><strong>Format Template:</strong></h6>
                <table class="table table-sm table-bordered">
                    <thead>
                        <tr>
                            <th>Kolom</th>
                            <th>Wajib</th>
                            <th>Contoh</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Nama Lengkap</td>
                            <td><span class="badge badge-danger">Ya</span></td>
                            <td>John Doe</td>
                        </tr>
                        <tr>
                            <td>Email</td>
                            <td><span class="badge badge-danger">Ya</span></td>
                            <td>john@example.com</td>
                        </tr>
                        <tr>
                            <td>Phone</td>
                            <td><span class="badge badge-secondary">Tidak</span></td>
                            <td>081234567890</td>
                        </tr>
                        <tr>
                            <td>Password</td>
                            <td><span class="badge badge-secondary">Tidak</span></td>
                            <td>password123</td>
                        </tr>
                        <tr>
                            <td>Role</td>
                            <td><span class="badge badge-secondary">Tidak</span></td>
                            <td>guru, Pengawas, ADMIN (case-insensitive)</td>
                        </tr>
                        <tr>
                            <td>Status</td>
                            <td><span class="badge badge-secondary">Tidak</span></td>
                            <td>Aktif, AKTIF, aktif (case-insensitive)</td>
                        </tr>
                    </tbody>
                </table>

                <div class="alert alert-warning">
                    <small>
                        <strong>Catatan:</strong> Template sudah berisi contoh data yang bisa dihapus dan diganti dengan data asli Anda.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Update file input label
document.getElementById('file').addEventListener('change', function(e) {
    const fileName = e.target.files[0]?.name || 'Choose file';
    const label = e.target.nextElementSibling;
    label.textContent = fileName;
});

// Download template with fallback
function downloadTemplate(event) {
    event.preventDefault();
    
    // Try admin route first
    fetch('{{ route("admin.users.download-template") }}')
        .then(response => {
            if (response.ok) {
                // If successful, trigger download
                window.location.href = '{{ route("admin.users.download-template") }}';
            } else {
                // If failed, use public route as fallback
                console.log('Admin route failed, using public route');
                window.location.href = '{{ route("public.users.template") }}';
            }
        })
        .catch(error => {
            console.log('Error with admin route, using public route:', error);
            window.location.href = '{{ route("public.users.template") }}';
        });
}

// Submit import with fallback
function submitImport(event) {
    event.preventDefault();
    
    const form = document.getElementById('importForm');
    const formData = new FormData(form);
    
    // Try admin route first
    fetch('{{ route("admin.users.import") }}', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        if (response.ok) {
            // If successful, submit to admin route
            form.action = '{{ route("admin.users.import") }}';
            form.submit();
        } else {
            // If failed, use public route as fallback
            console.log('Admin route failed, using public route');
            form.action = '{{ route("public.users.import.store") }}';
            form.submit();
        }
    })
    .catch(error => {
        console.log('Error with admin route, using public route:', error);
        form.action = '{{ route("public.users.import.store") }}';
        form.submit();
    });
}
</script>
@endpush
@endsection
