@extends('layouts.app')

@section('title', 'Sub Komponen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.show', $komponen->instrumen) }}">{{ $komponen->instrumen->judul }}</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.komponen-penilaian.index', $komponen->instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item active">Sub Komponen</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-layer-group"></i> Sub Komponen Penilaian
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.sub-komponen.create', $komponen) }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> Tambah Sub Komponen
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Komponen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-cogs"></i> {{ $komponen->nama_komponen }}</h5>
            <p class="mb-0">{{ $komponen->deskripsi }}</p>
            <small>Instrumen: {{ $komponen->instrumen->judul }} - Urutan: {{ $komponen->urutan }}</small>
        </div>

        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">No</th>
                        <th width="30%">Nama Sub Komponen</th>
                        <th width="35%">Deskripsi</th>
                        <th width="15%">Instrumen</th>
                        <th width="8%">Status</th>
                        <th width="17%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subKomponens as $index => $subKomponen)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <div>
                                <strong>{{ $subKomponen->nama_sub_komponen }}</strong>
                                <br><small class="text-muted">Urutan: {{ $subKomponen->urutan }}</small>
                            </div>
                        </td>
                        <td>
                            <div class="text-muted">
                                {{ $subKomponen->deskripsi ? Str::limit($subKomponen->deskripsi, 100) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-warning">{{ $subKomponen->instrumenPenilaians()->count() }} Item</span>
                        </td>
                        <td>
                            <span class="badge badge-{{ $subKomponen->is_active ? 'success' : 'danger' }}">
                                {{ $subKomponen->is_active ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.instrumen-penilaian.index', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" class="btn btn-info btn-sm" title="Lihat Instrumen">
                                    <i class="fas fa-list"></i>
                                </a>
                                <a href="{{ route('admin.sub-komponen.edit', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.sub-komponen.destroy', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus sub komponen ini?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">
                            <div class="py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada sub komponen penilaian. <a href="{{ route('admin.sub-komponen.create', $komponen) }}">Tambah sub komponen pertama</a></p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
