@extends('layouts.app')

@section('title', 'Tambah Sub Komponen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.show', $komponen->instrumen) }}">{{ $komponen->instrumen->judul }}</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.komponen-penilaian.index', $komponen->instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.sub-komponen.index', $komponen) }}">Sub Komponen</a></li>
<li class="breadcrumb-item active">Tambah</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-plus"></i> Tambah Sub Komponen
        </h3>
    </div>
    <div class="card-body">
        <!-- Komponen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-cogs"></i> {{ $komponen->nama_komponen }}</h5>
            <p class="mb-0">{{ $komponen->deskripsi }}</p>
            <small>Instrumen: {{ $komponen->instrumen->judul }}</small>
        </div>

        <form action="{{ route('admin.sub-komponen.store', $komponen) }}" method="POST" id="subKomponenForm">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_sub_komponen">Nama Sub Komponen <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nama_sub_komponen') is-invalid @enderror" 
                               id="nama_sub_komponen" name="nama_sub_komponen" 
                               value="{{ old('nama_sub_komponen') }}" required>
                        @error('nama_sub_komponen')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="urutan">Urutan <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('urutan') is-invalid @enderror" 
                               id="urutan" name="urutan" value="{{ old('urutan', 1) }}" 
                               min="1" required>
                        @error('urutan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="deskripsi">Deskripsi</label>
                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                          id="deskripsi" name="deskripsi" rows="4">{{ old('deskripsi') }}</textarea>
                @error('deskripsi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <div class="form-check">
                    <input type="hidden" name="is_active" value="0">
                    <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" 
                           {{ old('is_active', true) ? 'checked' : '' }}>
                    <label class="form-check-label" for="is_active">
                        Aktif
                    </label>
                </div>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary" id="submitBtn" onclick="console.log('Button clicked'); return true;">
                    <i class="fas fa-save"></i> Simpan
                </button>
                <a href="{{ route('admin.sub-komponen.index', $komponen) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('subKomponenForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        console.log('Form submitted');
        console.log('Form action:', form.action);
        console.log('Form method:', form.method);
        
        // Show loading state
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Menyimpan...';
        submitBtn.disabled = true;
        
        // Log form data
        const formData = new FormData(form);
        console.log('Form data:');
        for (let [key, value] of formData.entries()) {
            console.log(key + ': ' + value);
        }
    });
});
</script>
@endpush
