@extends('layouts.app')

@section('title', 'Pengaturan Sistem')

@section('content')
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        <i class="fas fa-cog"></i> Pengaturan Sistem
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Pengaturan</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            <div class="row">
                <!-- Profile Settings -->
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-user"></i> Profil Admin
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update-profile') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="name">Nama Lengkap</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name', $user->name ?? '') }}" required>
                                    @error('name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                           id="email" name="email" value="{{ old('email', $user->email) }}" required>
                                    @error('email')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="phone">No. Telepon</label>
                                    <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                           id="phone" name="phone" value="{{ old('phone', $user->phone) }}">
                                    @error('phone')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="avatar">Foto Profil</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('avatar') is-invalid @enderror" 
                                               id="avatar" name="avatar" accept="image/*">
                                        <label class="custom-file-label" for="avatar">Choose file</label>
                                    </div>
                                    @error('avatar')
                                        <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                    @if($user->avatar)
                                        <small class="text-muted">Foto saat ini: {{ basename($user->avatar) }}</small>
                                    @endif
                                </div>

                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Simpan Profil
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Password Settings -->
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-lock"></i> Ubah Password
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update-password') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="current_password">Password Saat Ini</label>
                                    <input type="password" class="form-control @error('current_password') is-invalid @enderror" 
                                           id="current_password" name="current_password" required>
                                    @error('current_password')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="password">Password Baru</label>
                                    <input type="password" class="form-control @error('password') is-invalid @enderror" 
                                           id="password" name="password" required>
                                    @error('password')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="password_confirmation">Konfirmasi Password Baru</label>
                                    <input type="password" class="form-control" 
                                           id="password_confirmation" name="password_confirmation" required>
                                </div>

                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-key"></i> Ubah Password
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- App Settings -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-cogs"></i> Pengaturan Aplikasi
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update-app') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="app_name">Nama Aplikasi</label>
                                            <input type="text" class="form-control @error('app_name') is-invalid @enderror" 
                                                   id="app_name" name="app_name" value="{{ old('app_name', $settings->app_name) }}" required>
                                            @error('app_name')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="app_version">Versi Aplikasi</label>
                                            <input type="text" class="form-control @error('app_version') is-invalid @enderror" 
                                                   id="app_version" name="app_version" value="{{ old('app_version', $settings->app_version) }}" required>
                                            @error('app_version')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="app_author">Pembuat Aplikasi</label>
                                            <input type="text" class="form-control @error('app_author') is-invalid @enderror" 
                                                   id="app_author" name="app_author" value="{{ old('app_author', $settings->app_author) }}">
                                            @error('app_author')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="app_email">Email Aplikasi</label>
                                            <input type="email" class="form-control @error('app_email') is-invalid @enderror" 
                                                   id="app_email" name="app_email" value="{{ old('app_email', $settings->app_email) }}">
                                            @error('app_email')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="app_phone">Telepon</label>
                                            <input type="text" class="form-control @error('app_phone') is-invalid @enderror" 
                                                   id="app_phone" name="app_phone" value="{{ old('app_phone', $settings->app_phone) }}">
                                            @error('app_phone')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="app_website">Website</label>
                                            <input type="url" class="form-control @error('app_website') is-invalid @enderror" 
                                                   id="app_website" name="app_website" value="{{ old('app_website', $settings->app_website) }}">
                                            @error('app_website')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="app_timezone">Timezone</label>
                                            <select class="form-control @error('app_timezone') is-invalid @enderror" 
                                                    id="app_timezone" name="app_timezone" required>
                                                <option value="Asia/Jakarta" {{ $settings->app_timezone == 'Asia/Jakarta' ? 'selected' : '' }}>Asia/Jakarta</option>
                                                <option value="Asia/Makassar" {{ $settings->app_timezone == 'Asia/Makassar' ? 'selected' : '' }}>Asia/Makassar</option>
                                                <option value="Asia/Jayapura" {{ $settings->app_timezone == 'Asia/Jayapura' ? 'selected' : '' }}>Asia/Jayapura</option>
                                            </select>
                                            @error('app_timezone')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="app_locale">Bahasa</label>
                                            <select class="form-control @error('app_locale') is-invalid @enderror" 
                                                    id="app_locale" name="app_locale" required>
                                                <option value="id" {{ $settings->app_locale == 'id' ? 'selected' : '' }}>Indonesia</option>
                                                <option value="en" {{ $settings->app_locale == 'en' ? 'selected' : '' }}>English</option>
                                            </select>
                                            @error('app_locale')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>


                                        <div class="form-group">
                                            <label for="app_pagination">Jumlah Data per Halaman</label>
                                            <select class="form-control @error('app_pagination') is-invalid @enderror" 
                                                    id="app_pagination" name="app_pagination" required>
                                                <option value="5" {{ $settings->app_pagination == 5 ? 'selected' : '' }}>5</option>
                                                <option value="10" {{ $settings->app_pagination == 10 ? 'selected' : '' }}>10</option>
                                                <option value="25" {{ $settings->app_pagination == 25 ? 'selected' : '' }}>25</option>
                                                <option value="50" {{ $settings->app_pagination == 50 ? 'selected' : '' }}>50</option>
                                                <option value="100" {{ $settings->app_pagination == 100 ? 'selected' : '' }}>100</option>
                                            </select>
                                            @error('app_pagination')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="app_description">Deskripsi Aplikasi</label>
                                    <textarea class="form-control @error('app_description') is-invalid @enderror" 
                                              id="app_description" name="app_description" rows="3">{{ old('app_description', $settings->app_description) }}</textarea>
                                    @error('app_description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="app_address">Alamat</label>
                                    <textarea class="form-control @error('app_address') is-invalid @enderror" 
                                              id="app_address" name="app_address" rows="2">{{ old('app_address', $settings->app_address) }}</textarea>
                                    @error('app_address')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-save"></i> Simpan Pengaturan Aplikasi
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Logo & Favicon Settings -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-image"></i> Logo & Favicon
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update-app') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="app_logo">Logo Aplikasi</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('app_logo') is-invalid @enderror" 
                                               id="app_logo" name="app_logo" accept="image/*">
                                        <label class="custom-file-label" for="app_logo">Choose logo</label>
                                    </div>
                                    @error('app_logo')
                                        <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                    @if($settings->app_logo)
                                        <div class="mt-2">
                                            <img src="{{ asset('storage/' . $settings->app_logo) }}" alt="Logo" class="img-thumbnail" style="max-width: 150px;">
                                            <br>
                                            <small class="text-muted">{{ basename($settings->app_logo) }}</small>
                                            <br>
                                            <a href="{{ route('admin.settings.delete-logo') }}" class="btn btn-sm btn-danger mt-1" 
                                               onclick="return confirm('Hapus logo?')">
                                                <i class="fas fa-trash"></i> Hapus Logo
                                            </a>
                                        </div>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label for="app_favicon">Favicon</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('app_favicon') is-invalid @enderror" 
                                               id="app_favicon" name="app_favicon" accept="image/*">
                                        <label class="custom-file-label" for="app_favicon">Choose favicon</label>
                                    </div>
                                    @error('app_favicon')
                                        <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                    @if($settings->app_favicon)
                                        <div class="mt-2">
                                            <img src="{{ asset('storage/' . $settings->app_favicon) }}" alt="Favicon" class="img-thumbnail" style="max-width: 50px;">
                                            <br>
                                            <small class="text-muted">{{ basename($settings->app_favicon) }}</small>
                                            <br>
                                            <a href="{{ route('admin.settings.delete-favicon') }}" class="btn btn-sm btn-danger mt-1" 
                                               onclick="return confirm('Hapus favicon?')">
                                                <i class="fas fa-trash"></i> Hapus Favicon
                                            </a>
                                        </div>
                                    @endif
                                </div>

                                <button type="submit" class="btn btn-info">
                                    <i class="fas fa-upload"></i> Upload Logo/Favicon
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- System Settings -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-server"></i> Pengaturan Sistem
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update-system') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="app_maintenance" 
                                               name="app_maintenance" value="1" {{ $settings->app_maintenance ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="app_maintenance">
                                            Mode Maintenance
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="maintenance_message">Pesan Maintenance</label>
                                    <textarea class="form-control @error('maintenance_message') is-invalid @enderror" 
                                              id="maintenance_message" name="maintenance_message" rows="3" 
                                              placeholder="Sistem sedang dalam maintenance...">{{ old('maintenance_message', $settings->maintenance_message) }}</textarea>
                                    @error('maintenance_message')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="app_notifications" 
                                               name="app_notifications" value="1" {{ $settings->app_notifications ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="app_notifications">
                                            Aktifkan Notifikasi
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="app_logs" 
                                               name="app_logs" value="1" {{ $settings->app_logs ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="app_logs">
                                            Aktifkan Logging
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="backup_frequency">Frekuensi Backup</label>
                                    <select class="form-control @error('backup_frequency') is-invalid @enderror" 
                                            id="backup_frequency" name="backup_frequency" required>
                                        <option value="daily" {{ $settings->backup_frequency == 'daily' ? 'selected' : '' }}>Harian</option>
                                        <option value="weekly" {{ $settings->backup_frequency == 'weekly' ? 'selected' : '' }}>Mingguan</option>
                                        <option value="monthly" {{ $settings->backup_frequency == 'monthly' ? 'selected' : '' }}>Bulanan</option>
                                    </select>
                                    @error('backup_frequency')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="backup_retention">Retensi Backup (hari)</label>
                                    <input type="number" class="form-control @error('backup_retention') is-invalid @enderror" 
                                           id="backup_retention" name="backup_retention" 
                                           value="{{ old('backup_retention', $settings->backup_retention) }}" 
                                           min="1" max="365" required>
                                    @error('backup_retention')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-cog"></i> Simpan Pengaturan Sistem
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Gemini AI Settings -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-robot"></i> Pengaturan Gemini AI
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update-gemini') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="gemini_enabled" 
                                               name="gemini_enabled" value="1" {{ $settings->gemini_enabled ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="gemini_enabled">
                                            Aktifkan Gemini AI
                                        </label>
                                    </div>
                                    <small class="text-muted">Aktifkan untuk menggunakan fitur analisis AI pada raport penilaian</small>
                                </div>

                                <div class="form-group">
                                    <label for="gemini_api_key">API Key Gemini</label>
                                    <input type="password" class="form-control @error('gemini_api_key') is-invalid @enderror" 
                                           id="gemini_api_key" name="gemini_api_key" 
                                           value="{{ old('gemini_api_key', $settings->gemini_api_key) }}"
                                           placeholder="Masukkan API Key dari Google AI Studio">
                                    @error('gemini_api_key')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="text-muted">
                                        Dapatkan API key di <a href="https://makersuite.google.com/app/apikey" target="_blank">Google AI Studio</a>
                                    </small>
                                </div>

                                <div class="form-group">
                                    <label for="gemini_model">Model Gemini</label>
                                    <select class="form-control @error('gemini_model') is-invalid @enderror" 
                                            id="gemini_model" name="gemini_model" required>
                                        <option value="gemini-2.5-flash" {{ $settings->gemini_model == 'gemini-2.5-flash' ? 'selected' : '' }}>
                                            Gemini 2.5 Flash (Gratis - Cepat)
                                        </option>
                                        <option value="gemini-2.5-pro" {{ $settings->gemini_model == 'gemini-2.5-pro' ? 'selected' : '' }}>
                                            Gemini 2.5 Pro (Gratis - Berkualitas Tinggi)
                                        </option>
                                        <option value="gemini-1.5-flash-8b" {{ $settings->gemini_model == 'gemini-1.5-flash-8b' ? 'selected' : '' }}>
                                            Gemini 1.5 Flash 8B (Legacy)
                                        </option>
                                        <option value="gemini-1.5-flash" {{ $settings->gemini_model == 'gemini-1.5-flash' ? 'selected' : '' }}>
                                            Gemini 1.5 Flash (Legacy)
                                        </option>
                                        <option value="gemini-1.5-pro" {{ $settings->gemini_model == 'gemini-1.5-pro' ? 'selected' : '' }}>
                                            Gemini 1.5 Pro (Legacy)
                                        </option>
                                        <option value="gemini-pro" {{ $settings->gemini_model == 'gemini-pro' ? 'selected' : '' }}>
                                            Gemini Pro (Legacy)
                                        </option>
                                        <option value="gemini-pro-vision" {{ $settings->gemini_model == 'gemini-pro-vision' ? 'selected' : '' }}>
                                            Gemini Pro Vision (Pro)
                                        </option>
                                    </select>
                                    @error('gemini_model')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="text-muted">
                                        Gemini Flash: Cepat dan gratis | Gemini Pro: Berkualitas tinggi | Gemini Pro Vision: Berbayar dengan fitur vision
                                    </small>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="gemini_max_tokens">Max Tokens</label>
                                            <input type="number" class="form-control @error('gemini_max_tokens') is-invalid @enderror" 
                                                   id="gemini_max_tokens" name="gemini_max_tokens" 
                                                   value="{{ old('gemini_max_tokens', $settings->gemini_max_tokens) }}" 
                                                   min="1" max="8192" required>
                                            @error('gemini_max_tokens')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                            <small class="text-muted">Maksimal token untuk response (1-8192)</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="gemini_temperature">Temperature</label>
                                            <input type="number" class="form-control @error('gemini_temperature') is-invalid @enderror" 
                                                   id="gemini_temperature" name="gemini_temperature" 
                                                   value="{{ old('gemini_temperature', $settings->gemini_temperature) }}" 
                                                   min="0" max="2" step="0.01" required>
                                            @error('gemini_temperature')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                            <small class="text-muted">Kreativitas AI (0-2, 0.7 = seimbang)</small>
                                        </div>
                                    </div>
                                </div>

                                <div class="alert alert-info">
                                    <h6><i class="fas fa-info-circle"></i> Informasi Gemini AI:</h6>
                                    <ul class="mb-0">
                                        <li><strong>Gratis:</strong> Gemini Pro dengan limit 15 requests per menit</li>
                                        <li><strong>Pro:</strong> Gemini Pro Vision dengan limit lebih tinggi dan fitur advanced</li>
                                        <li>AI akan menganalisis hasil penilaian dan menghasilkan catatan kepala sekolah otomatis</li>
                                        <li>Analisis pengawas akan dihasilkan saat generate PDF raport</li>
                                    </ul>
                                </div>

                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-robot"></i> Simpan Pengaturan Gemini AI
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('scripts')
<script>
// Update file input labels
document.addEventListener('DOMContentLoaded', function() {
    // Avatar input
    document.getElementById('avatar').addEventListener('change', function(e) {
        const fileName = e.target.files[0]?.name || 'Choose file';
        const label = e.target.nextElementSibling;
        label.textContent = fileName;
    });

    // Logo input
    document.getElementById('app_logo').addEventListener('change', function(e) {
        const fileName = e.target.files[0]?.name || 'Choose logo';
        const label = e.target.nextElementSibling;
        label.textContent = fileName;
    });

    // Favicon input
    document.getElementById('app_favicon').addEventListener('change', function(e) {
        const fileName = e.target.files[0]?.name || 'Choose favicon';
        const label = e.target.nextElementSibling;
        label.textContent = fileName;
    });
});
</script>
@endpush
