@extends('layouts.app')

@section('title', 'Manajemen Lembaga')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.lembaga.index') }}">Lembaga</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Manajemen Lembaga
        </h3>
        <div class="card-tools">
            <div class="btn-group mr-2">
                <a href="{{ route('admin.lembaga.template') }}" class="btn btn-outline-secondary btn-sm" title="Unduh Template">
                    <i class="fas fa-file-excel"></i> Template
                </a>
                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="$('#importModal').modal('show')">
                    <i class="fas fa-file-upload"></i> Import
                </button>
                <a href="{{ route('admin.lembaga.create') }}" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> Tambah Lembaga
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('warning'))
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                {{ session('warning') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Filter Form -->
        <div class="row mb-3">
            <div class="col-md-12">
                <form method="GET" action="{{ route('admin.lembaga.index') }}" class="form-inline">
                    <div class="form-group mr-2">
                        <select name="jenis" class="form-control form-control-sm">
                            <option value="">Semua Jenis</option>
                            <option value="RA" {{ request('jenis') == 'RA' ? 'selected' : '' }}>RA (Raudhatul Athfal)</option>
                            <option value="MI" {{ request('jenis') == 'MI' ? 'selected' : '' }}>MI (Madrasah Ibtidaiyah)</option>
                            <option value="MTs" {{ request('jenis') == 'MTs' ? 'selected' : '' }}>MTs (Madrasah Tsanawiyah)</option>
                            <option value="MA" {{ request('jenis') == 'MA' ? 'selected' : '' }}>MA (Madrasah Aliyah)</option>
                        </select>
                    </div>
                    <div class="form-group mr-2">
                        <select name="pengawas_id" class="form-control form-control-sm">
                            <option value="">Semua Pengawas</option>
                            <option value="unassigned" {{ request('pengawas_id') == 'unassigned' ? 'selected' : '' }}>Belum ada pengawas</option>
                            @foreach(\App\Models\User::role('pengawas')->get() as $pengawas)
                                <option value="{{ $pengawas->id }}" {{ request('pengawas_id') == $pengawas->id ? 'selected' : '' }}>
                                    {{ $pengawas->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mr-2">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Cari nama lembaga, NSM, atau kepala..." value="{{ request('search') }}">
                    </div>
                    <button type="submit" class="btn btn-secondary btn-sm">
                        <i class="fas fa-search"></i> Filter
                    </button>
                    <a href="{{ route('admin.lembaga.index') }}" class="btn btn-outline-secondary btn-sm ml-2">
                        <i class="fas fa-times"></i> Reset
                    </a>
                </form>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">ID</th>
                        <th width="20%">Nama Lembaga</th>
                        <th width="8%">Jenis</th>
                        <th width="10%">NSM</th>
                        <th width="15%">Kepala</th>
                        <th width="12%">Status Akun</th>
                        <th width="12%">Pengawas</th>
                        <th width="8%">Guru</th>
                        <th width="10%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($lembaga as $item)
                    <tr>
                        <td>{{ $item->id }}</td>
                        <td>
                            <div>
                                <strong>{{ $item->nama_lembaga }}</strong>
                                <br><small class="text-muted">{{ $item->alamat_lengkap }}</small>
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-{{ $item->jenis == 'RA' ? 'primary' : ($item->jenis == 'MI' ? 'success' : ($item->jenis == 'MTs' ? 'info' : 'warning')) }}">
                                {{ $item->jenis }}
                            </span>
                        </td>
                        <td>{{ $item->npsn_nsm }}</td>
                        <td>
                            @if($item->kepala_id)
                                <div>
                                    <strong>{{ $item->kepala->name ?? 'User tidak ditemukan' }}</strong>
                                    <br><small class="text-muted">{{ $item->kepala->nip ?? $item->nip_kepala ?? 'NIP tidak tersedia' }}</small>
                                </div>
                            @else
                                <div>
                                    <strong>{{ $item->nama_kepala ?? 'Belum ada kepala' }}</strong>
                                    <br><small class="text-muted">{{ $item->nip_kepala ?? 'NIP tidak tersedia' }}</small>
                                </div>
                            @endif
                        </td>
                        <td>
                            @if($item->kepala_id)
                                <span class="badge badge-success">
                                    <i class="fas fa-check"></i> Terintegrasi
                                </span>
                                <br><small class="text-muted">{{ $item->kepala->name ?? 'User tidak ditemukan' }}</small>
                            @else
                                <span class="badge badge-warning">
                                    <i class="fas fa-exclamation-triangle"></i> Belum terintegrasi
                                </span>
                            @endif
                        </td>
                        <td>
                            @if($item->pengawas)
                                <span class="badge badge-info">{{ $item->pengawas->name }}</span>
                            @else
                                <span class="badge badge-secondary">Belum ada pengawas</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge badge-warning">{{ $item->guru()->count() }} Guru</span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.lembaga.show', $item) }}" class="btn btn-info btn-sm" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.lembaga.edit', $item) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if(!$item->kepala_id)
                                <button type="button" class="btn btn-success btn-sm" title="Assign Kepala" data-toggle="modal" data-target="#assignKepalaModal" data-lembaga-id="{{ $item->id }}" data-lembaga-name="{{ $item->nama_lembaga }}" data-nama-kepala="{{ $item->nama_kepala }}" data-nip-kepala="{{ $item->nip_kepala }}">
                                    <i class="fas fa-user-plus"></i>
                                </button>
                                @else
                                <button type="button" class="btn btn-secondary btn-sm" title="Ubah Kepala" data-toggle="modal" data-target="#assignKepalaModal" data-lembaga-id="{{ $item->id }}" data-lembaga-name="{{ $item->nama_lembaga }}" data-nama-kepala="{{ $item->nama_kepala }}" data-nip-kepala="{{ $item->nip_kepala }}" data-current-kepala="{{ $item->kepala->name }}">
                                    <i class="fas fa-user-edit"></i>
                                </button>
                                @endif
                                @if($item->pengawas_id == null && $item->guru()->count() == 0)
                                <form action="{{ route('admin.lembaga.destroy', $item) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus lembaga ini?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="fas fa-school fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Tidak ada data lembaga</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center mt-3">
            {{ $lembaga->appends(request()->query())->links('pagination::bootstrap-4-custom') }}
        </div>
    </div>
</div>

@push('styles')
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-theme@0.1.0-beta.10/select2-bootstrap.min.css" rel="stylesheet" />

<style>
    /* Hide duplicate pagination if any */
    .card-body > .d-flex:not(:last-child) nav,
    .card-body > nav:not(:last-of-type) {
        display: none !important;
    }
    
    /* Fix pagination arrow button sizes - make all buttons consistent */
    .pagination .page-link {
        min-width: 38px;
        text-align: center;
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem !important;
        line-height: 1.5;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Specifically target first and last buttons (prev/next arrows) */
    .pagination .page-item:first-child .page-link,
    .pagination .page-item:last-child .page-link {
        min-width: 38px;
        max-width: 38px;
        font-size: 0.875rem !important;
        padding: 0.5rem 0.5rem;
        font-weight: normal;
    }
    
    /* Ensure all page links have same height */
    .pagination .page-item {
        height: 38px;
    }
    
    .pagination .page-item .page-link {
        height: 38px;
    }
    
    /* Hide duplicate navigation elements */
    .card-body nav ~ nav,
    .d-flex nav ~ nav {
        display: none !important;
    }
    
    /* Select2 styling for modal - default theme */
    .select2-container {
        width: 100% !important;
    }
    
    .select2-container .select2-dropdown {
        z-index: 9999;
        border: 1px solid #ced4da;
        border-radius: 0.25rem;
    }
    
    .select2-container .select2-selection--single {
        height: 38px !important;
        border: 1px solid #ced4da !important;
        border-radius: 0.25rem !important;
        background-color: #fff !important;
    }
    
    .select2-container .select2-selection--single .select2-selection__rendered {
        line-height: 36px !important;
        padding-left: 12px !important;
        padding-right: 40px !important;
        color: #495057 !important;
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .select2-container .select2-selection--single .select2-selection__arrow {
        height: 36px !important;
        right: 8px;
        top: 1px;
    }
    
    .select2-container .select2-selection--single .select2-selection__arrow b {
        border-color: #495057 transparent transparent transparent;
        border-width: 5px 4px 0 4px;
    }
    
    /* Position clear button (x) correctly */
    .select2-container .select2-selection--single .select2-selection__clear {
        position: absolute !important;
        right: 25px !important;
        top: 50% !important;
        transform: translateY(-50%) !important;
        cursor: pointer;
        font-size: 18px;
        line-height: 1;
        color: #999;
        margin-top: 0 !important;
    }
    
    .select2-container .select2-selection--single .select2-selection__clear:hover {
        color: #333;
    }
    
    /* Ensure Select2 container displays correctly */
    .select2-container {
        display: block;
        width: 100% !important;
    }
    
    /* Ensure Select2 container displays correctly */
    .form-group .select2-container {
        display: block !important;
        width: 100% !important;
        margin-bottom: 0 !important;
    }
    
    /* Make sure the rendered selection text is visible inside Select2 */
    .select2-container--bootstrap .select2-selection--single .select2-selection__rendered {
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
        width: calc(100% - 40px) !important;
    }
    
    /* Position clear button correctly */
    .select2-container--bootstrap .select2-selection--single .select2-selection__clear {
        position: absolute;
        right: 30px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 18px;
        line-height: 1;
        color: #999;
    }
    
    .select2-container--bootstrap .select2-selection--single .select2-selection__clear:hover {
        color: #333;
    }
    
    /* Hide the original select element properly */
    #kepala_id.select2-hidden-accessible {
        position: absolute !important;
        width: 1px !important;
        height: 1px !important;
        opacity: 0 !important;
        overflow: hidden !important;
    }
    
    /* Fix Select2 in modal */
    .modal .select2-container {
        z-index: 9999;
    }
    
    /* Ensure Select2 selection displays correctly */
    .select2-container--bootstrap .select2-selection--single .select2-selection__rendered {
        max-width: 100%;
    }
</style>
@endpush

<!-- Assign Kepala Modal -->
<div class="modal fade" id="assignKepalaModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <form action="{{ route('admin.lembaga.assign-kepala') }}" method="POST">
        @csrf
        <div class="modal-header">
          <h5 class="modal-title">Assign Kepala ke Lembaga</h5>
          <button type="button" class="close" data-dismiss="modal">
            <span>&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="lembaga_id" id="modal-lembaga-id">
          
          <div class="alert alert-info">
            <h6><i class="fas fa-info-circle"></i> Informasi Lembaga:</h6>
            <p class="mb-1"><strong>Nama:</strong> <span id="modal-lembaga-name"></span></p>
            <p class="mb-1"><strong>Kepala:</strong> <span id="modal-nama-kepala"></span></p>
            <p class="mb-0"><strong>NIP:</strong> <span id="modal-nip-kepala"></span></p>
          </div>

          <div class="form-group">
            <label for="kepala_id">Pilih Akun Kepala</label>
            @php
                $availableKepala = \App\Models\User::role('kepala')->whereDoesntHave('lembagaKepala')->get();
            @endphp
            
            @if($availableKepala->count() > 0)
                <select name="kepala_id" id="kepala_id" class="form-control select2 @error('kepala_id') is-invalid @enderror" required>
                  <option value="">Pilih akun kepala...</option>
                  @foreach($availableKepala as $kepala)
                    <option value="{{ $kepala->id }}" {{ old('kepala_id') == $kepala->id ? 'selected' : '' }}>
                      {{ $kepala->name }} ({{ $kepala->email }})
                    </option>
                  @endforeach
                </select>
            @else
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i> 
                    Tidak ada kepala yang tersedia untuk diassign. Semua kepala sudah memiliki lembaga.
                </div>
                <input type="hidden" name="kepala_id" value="">
            @endif
            @error('kepala_id')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
            <small class="form-text text-muted">
              Hanya menampilkan kepala yang belum memiliki lembaga. Jika belum ada akun kepala tersedia, buat terlebih dahulu di menu User Management.
            </small>
          </div>

          <div class="alert alert-warning">
            <h6><i class="fas fa-exclamation-triangle"></i> Perhatian:</h6>
            <ul class="mb-0">
              <li><strong>1 Lembaga = 1 Kepala:</strong> Setiap lembaga hanya bisa memiliki 1 kepala.</li>
              <li>Hanya kepala yang belum memiliki lembaga yang ditampilkan dalam dropdown ini.</li>
              <li>Pastikan data kepala di lembaga sesuai dengan akun yang dipilih.</li>
              <li>Kepala yang sudah diassign akan bisa login dan mengelola lembaga ini.</li>
              <li>Jika lembaga sudah memiliki kepala, gunakan tombol "Ubah Kepala" untuk menggantinya.</li>
            </ul>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-user-plus"></i> Assign Kepala
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 for kepala dropdown (will be reinitialized when modal opens)
    function initSelect2() {
        var $select = $('#kepala_id');
        if ($select.length && !$select.hasClass('select2-hidden-accessible')) {
            // Destroy any existing instance first
            if ($select.hasClass('select2-hidden-accessible')) {
                $select.select2('destroy');
            }
            
            // Initialize Select2
            $select.select2({
                placeholder: 'Pilih akun kepala...',
                allowClear: true,
                width: '100%',
                dropdownAutoWidth: false,
                dropdownParent: $('#assignKepalaModal'),
                language: {
                    noResults: function() {
                        return "Tidak ada kepala tersedia";
                    },
                    searching: function() {
                        return "Mencari...";
                    },
                    inputTooShort: function() {
                        return "Ketik minimal 1 karakter untuk mencari";
                    }
                }
            });
            
            // Force update display after Select2 is initialized
            setTimeout(function() {
                if ($select.val()) {
                    var selectedText = $select.find('option:selected').text();
                    var $container = $select.next('.select2-container');
                    if ($container.length) {
                        var $rendered = $container.find('.select2-selection__rendered');
                        if ($rendered.length) {
                            $rendered.text(selectedText).attr('title', selectedText);
                        }
                    }
                }
            }, 50);
            
            // Update display when selection changes
            $select.on('select2:select select2:clearing', function (e) {
                setTimeout(function() {
                    var selectedText = $select.find('option:selected').text();
                    var $container = $select.next('.select2-container');
                    if ($container.length) {
                        var $rendered = $container.find('.select2-selection__rendered');
                        if ($rendered.length) {
                            if (selectedText) {
                                $rendered.text(selectedText).attr('title', selectedText);
                            } else {
                                $rendered.text('Pilih akun kepala...');
                            }
                        }
                    }
                }, 10);
            });
            
        }
    }
    
    $('#assignKepalaModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var lembagaId = button.data('lembaga-id');
        var lembagaName = button.data('lembaga-name');
        var namaKepala = button.data('nama-kepala');
        var nipKepala = button.data('nip-kepala');
        var currentKepala = button.data('current-kepala');

        var modal = $(this);
        modal.find('#modal-lembaga-id').val(lembagaId);
        modal.find('#modal-lembaga-name').text(lembagaName);
        modal.find('#modal-nama-kepala').text(namaKepala);
        modal.find('#modal-nip-kepala').text(nipKepala);
        
        // Destroy existing Select2 if any
        var $kepalaSelect = modal.find('#kepala_id');
        if ($kepalaSelect.length && $kepalaSelect.hasClass('select2-hidden-accessible')) {
            $kepalaSelect.select2('destroy');
        }
        
        // Reset select
        $kepalaSelect.val('').trigger('change');
        
        // Initialize Select2 after modal is fully shown
        setTimeout(function() {
            initSelect2();
            
            // Ensure Select2 container is properly styled and visible
            var $select2Container = $kepalaSelect.next('.select2-container');
            if ($select2Container.length) {
                $select2Container.css({
                    'width': '100%',
                    'display': 'block'
                });
                
                // Force update the rendered text if there's a value
                if ($kepalaSelect.val()) {
                    var selectedText = $kepalaSelect.find('option:selected').text();
                    var $rendered = $select2Container.find('.select2-selection__rendered');
                    if ($rendered.length) {
                        $rendered.text(selectedText).attr('title', selectedText);
                    }
                }
            }
        }, 200);
        
        // Pre-select current kepala if exists
        if (currentKepala) {
            modal.find('.modal-title').text('Ubah Kepala Lembaga');
            modal.find('button[type="submit"]').html('<i class="fas fa-user-edit"></i> Ubah Kepala');
        } else {
            modal.find('.modal-title').text('Assign Kepala ke Lembaga');
            modal.find('button[type="submit"]').html('<i class="fas fa-user-plus"></i> Assign Kepala');
        }
    });
    
    // Clean up Select2 when modal is closed
    $('#assignKepalaModal').on('hidden.bs.modal', function () {
        if ($('#kepala_id').hasClass('select2-hidden-accessible')) {
            $('#kepala_id').select2('destroy');
        }
    });
});
</script>
@endpush

@push('scripts')
<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" role="dialog" aria-labelledby="importModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="importModalLabel"><i class="fas fa-file-upload"></i> Import Lembaga (.xlsx)</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="{{ route('admin.lembaga.import') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="modal-body">
            <div class="alert alert-info">
                <strong>Petunjuk:</strong>
                <ul class="mb-0">
                    <li>Gunakan tombol <em>Template</em> untuk mengunduh contoh format.</li>
                    <li>Kolom wajib: <code>npsn_nsm, nama_lembaga, jenis</code>.</li>
                    <li>Nilai <code>jenis</code> harus salah satu dari: RA, MI, MTs, MA (tidak peka huruf besar-kecil).</li>
                    <li>Data lengkap akan dilengkapi nanti oleh kepala lembaga.</li>
                    <li>Pengawas akan memilih lembaga yang sudah dibuat untuk dibina.</li>
                </ul>
            </div>
            <div class="form-group">
                <label>Pilih file Excel (.xlsx)</label>
                <input type="file" name="file" class="form-control" accept=".xlsx" required>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
          <button type="submit" class="btn btn-primary">Upload</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endpush
