@extends('layouts.app')

@section('title', 'Tambah Lembaga')

@push('styles')
<style>
/* Styling sederhana untuk form admin */
.form-control {
    border-radius: 0.25rem;
}
</style>
@endpush

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.lembaga.index') }}">Lembaga</a></li>
<li class="breadcrumb-item active">Tambah</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Tambah Lembaga Baru
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.lembaga.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <strong>Informasi:</strong> Admin hanya perlu mengisi data utama lembaga. Data lengkap akan dilengkapi nanti oleh kepala lembaga.
        </div>
        
        <form action="{{ route('admin.lembaga.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="npsn_nsm">NSM <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('npsn_nsm') is-invalid @enderror" id="npsn_nsm" name="npsn_nsm" value="{{ old('npsn_nsm') }}" required placeholder="Masukkan NSM">
                        <small class="form-text text-muted">Nomor Statistik Madrasah</small>
                        @error('npsn_nsm')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="form-group">
                        <label for="nama_lembaga">Nama Lembaga <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nama_lembaga') is-invalid @enderror" id="nama_lembaga" name="nama_lembaga" value="{{ old('nama_lembaga') }}" required placeholder="Masukkan nama lembaga">
                        @error('nama_lembaga')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="jenis">Jenis Lembaga <span class="text-danger">*</span></label>
                        <select class="form-control @error('jenis') is-invalid @enderror" id="jenis" name="jenis" required>
                            <option value="">Pilih Jenis</option>
                            <option value="RA" {{ old('jenis') == 'RA' ? 'selected' : '' }}>RA (Raudhatul Athfal)</option>
                            <option value="MI" {{ old('jenis') == 'MI' ? 'selected' : '' }}>MI (Madrasah Ibtidaiyah)</option>
                            <option value="MTs" {{ old('jenis') == 'MTs' ? 'selected' : '' }}>MTs (Madrasah Tsanawiyah)</option>
                            <option value="MA" {{ old('jenis') == 'MA' ? 'selected' : '' }}>MA (Madrasah Aliyah)</option>
                        </select>
                        @error('jenis')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
                <a href="{{ route('admin.lembaga.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Form sederhana untuk admin - tidak perlu JavaScript khusus
});
</script>
@endpush
