@extends('layouts.app')

@section('title', 'Komponen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.show', $instrumen) }}">{{ $instrumen->judul }}</a></li>
<li class="breadcrumb-item active">Komponen Penilaian</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-cogs"></i> Komponen Penilaian
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.komponen-penilaian.create', $instrumen) }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> Tambah Komponen
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Instrumen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-clipboard-list"></i> {{ $instrumen->judul }}</h5>
            <p class="mb-0">{{ $instrumen->deskripsi }}</p>
            <small>Tahun Ajaran: {{ $instrumen->tahun_ajaran }} - Semester {{ $instrumen->semester }}</small>
        </div>

        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">No</th>
                        <th width="30%">Nama Komponen</th>
                        <th width="40%">Deskripsi</th>
                        <th width="10%">Instrumen</th>
                        <th width="8%">Status</th>
                        <th width="17%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($komponenPenilaians as $index => $komponen)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <div>
                                <strong>{{ $komponen->nama_komponen }}</strong>
                                <br><small class="text-muted">Urutan: {{ $komponen->urutan }}</small>
                            </div>
                        </td>
                        <td>
                            <div class="text-muted">
                                {{ $komponen->deskripsi ? Str::limit($komponen->deskripsi, 100) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-warning">{{ $komponen->instrumenPenilaians()->count() }} Item</span>
                        </td>
                        <td>
                            <span class="badge badge-{{ $komponen->is_active ? 'success' : 'danger' }}">
                                {{ $komponen->is_active ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.sub-komponen.index', $komponen) }}" class="btn btn-success btn-sm" title="Lihat Sub Komponen">
                                    <i class="fas fa-layer-group"></i>
                                </a>
                                <a href="{{ route('admin.komponen-penilaian.edit', $komponen) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.komponen-penilaian.destroy', $komponen) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus komponen ini?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">
                            <div class="py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada komponen penilaian. <a href="{{ route('admin.komponen-penilaian.create', $instrumen) }}">Tambah komponen pertama</a></p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
