@extends('layouts.app')

@section('title', 'Edit Komponen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.show', $komponen->instrumen) }}">{{ $komponen->instrumen->judul }}</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.komponen-penilaian.index', $komponen->instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-edit"></i> Edit Komponen Penilaian
        </h3>
    </div>
    <div class="card-body">
        <!-- Instrumen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-clipboard-list"></i> {{ $komponen->instrumen->judul }}</h5>
            <p class="mb-0">{{ $komponen->instrumen->deskripsi }}</p>
            <small>Tahun Ajaran: {{ $komponen->instrumen->tahun_ajaran }} - Semester {{ $komponen->instrumen->semester }}</small>
        </div>

        <form action="{{ route('admin.komponen-penilaian.update', $komponen) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_komponen">Nama Komponen <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nama_komponen') is-invalid @enderror" 
                               id="nama_komponen" name="nama_komponen" value="{{ old('nama_komponen', $komponen->nama_komponen) }}" 
                               required placeholder="Masukkan nama komponen">
                        @error('nama_komponen')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="urutan">Urutan <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('urutan') is-invalid @enderror" 
                               id="urutan" name="urutan" value="{{ old('urutan', $komponen->urutan) }}" 
                               required min="1">
                        @error('urutan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">Urutan komponen dalam instrumen</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="is_active">Status</label>
                        <select class="form-control @error('is_active') is-invalid @enderror" id="is_active" name="is_active">
                            <option value="1" {{ old('is_active', $komponen->is_active) == '1' ? 'selected' : '' }}>Aktif</option>
                            <option value="0" {{ old('is_active', $komponen->is_active) == '0' ? 'selected' : '' }}>Nonaktif</option>
                        </select>
                        @error('is_active')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="deskripsi">Deskripsi Komponen</label>
                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                          id="deskripsi" name="deskripsi" rows="4" 
                          placeholder="Masukkan deskripsi komponen penilaian">{{ old('deskripsi', $komponen->deskripsi) }}</textarea>
                @error('deskripsi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="form-text text-muted">Jelaskan apa yang dinilai dalam komponen ini</small>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Komponen
                </button>
                <a href="{{ route('admin.komponen-penilaian.index', $komponen->instrumen) }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
