@extends('layouts.app')

@section('title', 'Detail Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Detail</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-clipboard-list"></i> Detail Instrumen: {{ $instrumen->judul }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.instrumen.export-excel', $instrumen) }}" class="btn btn-success btn-sm">
                <i class="fas fa-file-excel"></i> Export Excel
            </a>
            <a href="{{ route('admin.instrumen.edit', $instrumen) }}" class="btn btn-warning btn-sm">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('admin.instrumen.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Umum</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <strong>Judul Instrumen:</strong><br>
                                <span class="text-primary">{{ $instrumen->judul }}</span><br><br>
                                
                                <strong>Status:</strong><br>
                                <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                    {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span><br><br>
                                
                                <strong>Tahun Ajaran:</strong><br>
                                <span class="text-success">{{ $instrumen->tahun_ajaran }}</span><br><br>
                                
                                <strong>Semester:</strong><br>
                                <span class="badge badge-secondary">Semester {{ $instrumen->semester }}</span><br><br>
                                
                                <strong>Status:</strong><br>
                                <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                    {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span>
                            </div>
                            <div class="col-md-6">
                                <strong>Deskripsi:</strong><br>
                                <span class="text-muted">{{ $instrumen->deskripsi ?: 'Tidak ada deskripsi' }}</span><br><br>
                                
                                <strong>Tanggal Dibuat:</strong><br>
                                <span class="text-info">{{ $instrumen->created_at->format('d/m/Y H:i') }}</span><br><br>
                                
                                <strong>Terakhir Diupdate:</strong><br>
                                <span class="text-warning">{{ $instrumen->updated_at->format('d/m/Y H:i') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Statistik</h3>
                    </div>
                    <div class="card-body">
                        <div class="info-box bg-primary">
                            <span class="info-box-icon"><i class="fas fa-list"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Total Komponen</span>
                                <span class="info-box-number">{{ $instrumen->komponenPenilaians()->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-success">
                            <span class="info-box-icon"><i class="fas fa-share-alt"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Distribusi</span>
                                <span class="info-box-number">{{ $instrumen->distribusiInstrumen()->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-warning">
                            <span class="info-box-icon"><i class="fas fa-school"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Lembaga</span>
                                <span class="info-box-number">{{ $instrumen->distribusiInstrumen()->distinct('lembaga_id')->count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if($instrumen->komponenPenilaians()->count() > 0)
        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-list-alt"></i> 
                    Struktur Instrumen Penilaian
                </h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-dark">
                            <tr>
                                <th width="8%">No</th>
                                <th width="35%">Indikator Kerja</th>
                                <th width="30%">Evidensi Kerja</th>
                                <th width="8%">Skor Min</th>
                                <th width="8%">Skor Max</th>
                                <th width="11%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $rowNumber = 1;
                                $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                            @endphp
                            
                            @foreach($instrumen->komponenPenilaians()->orderBy('urutan')->get() as $komponenIndex => $komponen)
                                <!-- Komponen Row (Level Tertinggi) -->
                                <tr class="table-dark">
                                    <td><strong>{{ $komponenIndex + 1 }}</strong></td>
                                    <td>
                                        <strong>{{ $komponen->nama_komponen }}</strong>
                                        @if($komponen->deskripsi)
                                            <br><small class="text-muted">{{ $komponen->deskripsi }}</small>
                                        @endif
                                    </td>
                                    <td colspan="3">
                                        <span class="badge badge-dark">Komponen</span>
                                        <span class="badge badge-secondary">{{ $komponen->subKomponens->count() }} Sub Komponen</span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.komponen-penilaian.edit', $komponen) }}" 
                                               class="btn btn-warning btn-sm" title="Edit Komponen">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                
                                @foreach($komponen->subKomponens()->orderBy('urutan')->get() as $subKomponenIndex => $subKomponen)
                                    <!-- Sub Komponen Row (A, B, C, dst.) -->
                                    <tr class="table-primary">
                                        <td><strong>{{ $komponenLetters[$subKomponenIndex] }}</strong></td>
                                        <td>
                                            <strong>{{ $subKomponen->nama_sub_komponen }}</strong>
                                            @if($subKomponen->deskripsi)
                                                <br><small class="text-muted">{{ $subKomponen->deskripsi }}</small>
                                            @endif
                                        </td>
                                        <td colspan="3">
                                            <span class="badge badge-info">Sub Komponen</span>
                                            <span class="badge badge-light">{{ $subKomponen->instrumenPenilaians->count() }} Instrumen</span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.sub-komponen.edit', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" 
                                                   class="btn btn-warning btn-sm" title="Edit Sub Komponen">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    
                                    @foreach($subKomponen->instrumenPenilaians()->orderBy('no_urutan')->get() as $instrumenItem)
                                        <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                        <tr class="table-light">
                                            <td>
                                                <strong>{{ $komponenLetters[$subKomponenIndex] }}{{ $instrumenItem->no_urutan }}</strong>
                                            </td>
                                            <td>
                                                <div class="text-sm">
                                                    <strong>{{ $instrumenItem->indikator_kinerja }}</strong>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="text-sm">
                                                    {{ $instrumenItem->evidensi_kinerja }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge badge-success">{{ $instrumenItem->skor_min }}</span>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge badge-danger">{{ $instrumenItem->skor_max }}</span>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="{{ route('admin.instrumen-penilaian.edit', $instrumenItem) }}" 
                                                       class="btn btn-warning btn-sm" title="Edit Instrumen">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Summary Information -->
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <h5><i class="fas fa-info-circle"></i> Ringkasan Struktur</h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <strong>Total Komponen:</strong> {{ $instrumen->komponenPenilaians()->count() }}
                                </div>
                                <div class="col-md-3">
                                    <strong>Total Sub Komponen:</strong> {{ $instrumen->komponenPenilaians()->withCount('subKomponens')->get()->sum('sub_komponens_count') }}
                                </div>
                                <div class="col-md-3">
                                    <strong>Total Instrumen:</strong> {{ $instrumen->komponenPenilaians()->withCount(['subKomponens' => function($query) { $query->withCount('instrumenPenilaians'); }])->get()->sum('sub_komponens_count') }}
                                </div>
                                <div class="col-md-3">
                                    <strong>Status:</strong> 
                                    <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                        {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        @if($instrumen->distribusiInstrumen()->count() > 0)
        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">Distribusi ke Lembaga ({{ $instrumen->distribusiInstrumen()->count() }})</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Lembaga</th>
                                <th>Tanggal Distribusi</th>
                                <th>Deadline</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($instrumen->distribusiInstrumen as $distribusi)
                            <tr>
                                <td>
                                    <strong>{{ $distribusi->lembaga->nama_lembaga }}</strong><br>
                                    <small class="text-muted">{{ $distribusi->lembaga->jenis }}</small>
                                </td>
                                <td>{{ \Carbon\Carbon::parse($distribusi->tanggal_distribusi)->format('d/m/Y') }}</td>
                                <td>{{ \Carbon\Carbon::parse($distribusi->deadline)->format('d/m/Y') }}</td>
                                <td>
                                    <span class="badge badge-{{ $distribusi->status == 'active' ? 'success' : 'secondary' }}">
                                        {{ ucfirst($distribusi->status) }}
                                    </span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection
