@extends('layouts.app')

@section('title', 'Manajemen Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-clipboard-list"></i> Manajemen Instrumen
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.instrumen.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> Tambah Instrumen
            </a>
        </div>
    </div>
    <div class="card-body">
        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Filter Form -->
        <div class="row mb-3">
            <div class="col-md-12">
                <form method="GET" action="{{ route('admin.instrumen.index') }}" class="form-inline">
                    <div class="form-group mr-2">
                        <select name="is_active" class="form-control form-control-sm">
                            <option value="">Semua Status</option>
                            <option value="1" {{ request('is_active') == '1' ? 'selected' : '' }}>Aktif</option>
                            <option value="0" {{ request('is_active') == '0' ? 'selected' : '' }}>Nonaktif</option>
                        </select>
                    </div>
                    <div class="form-group mr-2">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Cari judul atau tahun ajaran..." value="{{ request('search') }}">
                    </div>
                    <button type="submit" class="btn btn-secondary btn-sm">
                        <i class="fas fa-search"></i> Filter
                    </button>
                    <a href="{{ route('admin.instrumen.index') }}" class="btn btn-outline-secondary btn-sm ml-2">
                        <i class="fas fa-times"></i> Reset
                    </a>
                </form>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">ID</th>
                        <th width="25%">Judul Instrumen</th>
                        <th width="12%">Tahun Ajaran</th>
                        <th width="8%">Semester</th>
                        <th width="10%">Komponen</th>
                        <th width="8%">Status</th>
                        <th width="17%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($instrumen as $item)
                    <tr>
                        <td>{{ $item->id }}</td>
                        <td>
                            <div>
                                <strong>{{ $item->judul }}</strong>
                                @if($item->deskripsi)
                                    <br><small class="text-muted">{{ Str::limit($item->deskripsi, 50) }}</small>
                                @endif
                            </div>
                        </td>
                        <td>{{ $item->tahun_ajaran }}</td>
                        <td>
                            <span class="badge badge-secondary">Semester {{ $item->semester }}</span>
                        </td>
                        <td>
                            <span class="badge badge-warning">{{ $item->komponenPenilaians()->count() }} Komponen</span>
                        </td>
                        <td>
                            <span class="badge badge-{{ $item->is_active ? 'success' : 'danger' }}">
                                {{ $item->is_active ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.instrumen.show', $item) }}" class="btn btn-info btn-sm" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.komponen-penilaian.index', $item) }}" class="btn btn-primary btn-sm" title="Kelola Komponen">
                                    <i class="fas fa-cogs"></i>
                                </a>
                                <a href="{{ route('admin.instrumen.edit', $item) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.instrumen.toggle-status', $item) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="btn btn-{{ $item->is_active ? 'secondary' : 'success' }} btn-sm" title="{{ $item->is_active ? 'Nonaktifkan' : 'Aktifkan' }}" onclick="return confirm('Apakah Anda yakin?')">
                                        <i class="fas fa-{{ $item->is_active ? 'ban' : 'check' }}"></i>
                                    </button>
                                </form>
                                @if($item->distribusiInstrumen()->count() == 0)
                                <form action="{{ route('admin.instrumen.destroy', $item) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus instrumen ini?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Tidak ada data instrumen</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center mt-3">
            {{ $instrumen->appends(request()->query())->links() }}
        </div>
    </div>
</div>
@endsection
