@extends('layouts.app')

@section('title', 'Edit Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-clipboard-list"></i> Edit Instrumen: {{ $instrumen->judul }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('admin.instrumen.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.instrumen.update', $instrumen) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-8">
                    <div class="form-group">
                        <label for="judul">Judul Instrumen <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('judul') is-invalid @enderror" id="judul" name="judul" value="{{ old('judul', $instrumen->judul) }}" required>
                        @error('judul')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="deskripsi">Deskripsi</label>
                <textarea class="form-control @error('deskripsi') is-invalid @enderror" id="deskripsi" name="deskripsi" rows="3">{{ old('deskripsi', $instrumen->deskripsi) }}</textarea>
                @error('deskripsi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="tahun_ajaran">Tahun Ajaran <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('tahun_ajaran') is-invalid @enderror" id="tahun_ajaran" name="tahun_ajaran" value="{{ old('tahun_ajaran', $instrumen->tahun_ajaran) }}" required>
                        @error('tahun_ajaran')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="semester">Semester <span class="text-danger">*</span></label>
                        <select class="form-control @error('semester') is-invalid @enderror" id="semester" name="semester" required>
                            <option value="">Pilih Semester</option>
                            <option value="1" {{ old('semester', $instrumen->semester) == '1' ? 'selected' : '' }}>Semester 1</option>
                            <option value="2" {{ old('semester', $instrumen->semester) == '2' ? 'selected' : '' }}>Semester 2</option>
                        </select>
                        @error('semester')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ old('is_active', $instrumen->is_active) ? 'checked' : '' }}>
                    <label class="form-check-label" for="is_active">
                        Status Aktif
                    </label>
                </div>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update
                </button>
                <a href="{{ route('admin.instrumen.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>

@if($instrumen->distribusiInstrumen->count() > 0)
<div class="card mt-4">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-calendar-alt"></i> Perpanjang Deadline Distribusi
        </h3>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <form action="{{ route('admin.instrumen.update-deadline', $instrumen) }}" method="POST" id="deadlineForm">
            @csrf
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="deadline">Deadline Baru <span class="text-danger">*</span></label>
                    <input type="date" class="form-control @error('deadline') is-invalid @enderror" 
                           id="deadline" name="deadline" 
                           value="{{ old('deadline', date('Y-m-d', strtotime('+30 days'))) }}" 
                           min="{{ date('Y-m-d', strtotime('+1 day')) }}" required>
                    @error('deadline')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="form-text text-muted">Pilih tanggal deadline baru (minimal besok)</small>
                </div>
                <div class="col-md-6 d-flex align-items-end">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="update_all" name="update_all" value="1" checked>
                        <label class="form-check-label" for="update_all">
                            Update semua distribusi aktif
                        </label>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th width="50">
                                <input type="checkbox" id="select_all" {{ old('update_all', true) ? 'checked' : '' }}>
                            </th>
                            <th>Lembaga</th>
                            <th>Tanggal Distribusi</th>
                            <th>Deadline Saat Ini</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($instrumen->distribusiInstrumen as $distribusi)
                        <tr>
                            <td>
                                <input type="checkbox" name="distribusi_ids[]" 
                                       value="{{ $distribusi->id }}" 
                                       class="distribusi-checkbox"
                                       {{ old('update_all', true) ? 'checked' : '' }}>
                            </td>
                            <td>
                                <strong>{{ $distribusi->lembaga->nama_lembaga }}</strong><br>
                                <small class="text-muted">{{ $distribusi->lembaga->jenis }}</small>
                            </td>
                            <td>{{ \Carbon\Carbon::parse($distribusi->tanggal_distribusi)->format('d/m/Y') }}</td>
                            <td>
                                {{ \Carbon\Carbon::parse($distribusi->deadline)->format('d/m/Y') }}
                                @if(\Carbon\Carbon::parse($distribusi->deadline)->isPast() && $distribusi->status == 'active')
                                    <span class="badge badge-danger ml-2">Terlambat</span>
                                @elseif(\Carbon\Carbon::parse($distribusi->deadline)->diffInDays() <= 7 && $distribusi->status == 'active')
                                    <span class="badge badge-warning ml-2">Mendekati Deadline</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-{{ $distribusi->status == 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($distribusi->status) }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="form-group mt-3">
                <button type="submit" class="btn btn-warning">
                    <i class="fas fa-calendar-plus"></i> Perpanjang Deadline
                </button>
            </div>
        </form>
    </div>
</div>
@endif

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectAll = document.getElementById('select_all');
    const updateAll = document.getElementById('update_all');
    const checkboxes = document.querySelectorAll('.distribusi-checkbox');
    
    // Toggle select all
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(cb => {
                cb.checked = this.checked;
            });
        });
    }
    
    // Toggle update all
    if (updateAll) {
        updateAll.addEventListener('change', function() {
            if (this.checked) {
                checkboxes.forEach(cb => {
                    cb.checked = true;
                    cb.disabled = true;
                });
                if (selectAll) selectAll.checked = true;
            } else {
                checkboxes.forEach(cb => {
                    cb.disabled = false;
                });
            }
        });
        
        // Initialize on load
        if (updateAll.checked) {
            checkboxes.forEach(cb => {
                cb.disabled = true;
            });
        }
    }
    
    // Update select all when individual checkbox changes
    checkboxes.forEach(cb => {
        cb.addEventListener('change', function() {
            if (!updateAll.checked) {
                const allChecked = Array.from(checkboxes).every(c => c.checked || c.disabled);
                if (selectAll) selectAll.checked = allChecked;
            }
        });
    });
});
</script>
@endpush
@endsection
