@extends('layouts.app')

@section('title', 'Instrumen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.show', $komponen->instrumen) }}">{{ $komponen->instrumen->judul }}</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.komponen-penilaian.index', $komponen->instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.sub-komponen.index', $komponen) }}">Sub Komponen</a></li>
<li class="breadcrumb-item active">Instrumen Penilaian</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-list"></i> Instrumen Penilaian
        </h3>
        <div class="card-tools">
            <button type="button" class="btn btn-success btn-sm mr-2" data-toggle="modal" data-target="#importModal">
                <i class="fas fa-file-import"></i> Import Excel
            </button>
            <a href="{{ route('admin.instrumen-penilaian.template', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" class="btn btn-info btn-sm mr-2">
                <i class="fas fa-download"></i> Template Excel
            </a>
            <a href="{{ route('admin.instrumen-penilaian.create', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> Tambah Instrumen
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Komponen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-cogs"></i> {{ $komponen->nama_komponen }}</h5>
            <p class="mb-0">{{ $komponen->deskripsi }}</p>
            <small>Instrumen: {{ $komponen->instrumen->judul }} - Urutan: {{ $komponen->urutan }}</small>
        </div>

        <!-- Sub Komponen Info -->
        <div class="alert alert-success">
            <h5><i class="fas fa-layer-group"></i> {{ $subKomponen->nama_sub_komponen }}</h5>
            <p class="mb-0">{{ $subKomponen->deskripsi }}</p>
            <small>Urutan: {{ $subKomponen->urutan }}</small>
        </div>

        <!-- Info Pembagian Peran -->
        <div class="alert alert-light">
            <h6><i class="fas fa-users"></i> Pembagian Peran dalam Penilaian:</h6>
            <div class="row">
                <div class="col-md-4">
                    <small class="text-muted">
                        <i class="fas fa-user-tie text-primary"></i> <strong>Admin:</strong> Membuat struktur instrumen
                    </small>
                </div>
                <div class="col-md-4">
                    <small class="text-muted">
                        <i class="fas fa-chalkboard-teacher text-success"></i> <strong>Guru:</strong> Mengisi Bukti URL
                    </small>
                </div>
                <div class="col-md-4">
                    <small class="text-muted">
                        <i class="fas fa-user-shield text-warning"></i> <strong>Kepala:</strong> Mengisi Catatan Verifikasi
                    </small>
                </div>
            </div>
        </div>

        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">No</th>
                        <th width="35%">Indikator Kinerja</th>
                        <th width="25%">Evidensi Kinerja</th>
                        <th width="8%">Skor</th>
                        <th width="10%">Bukti URL <small class="text-muted">(Guru)</small></th>
                        <th width="15%">Catatan <small class="text-muted">(Kepala)</small></th>
                        <th width="8%">Status</th>
                        <th width="17%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($instrumenPenilaians as $index => $instrumen)
                    <tr>
                        <td>{{ $instrumen->no_urutan }}</td>
                        <td>
                            <div class="text-justify">
                                {{ $instrumen->indikator_kinerja }}
                            </div>
                        </td>
                        <td>
                            <div class="text-muted text-justify">
                                {{ $instrumen->evidensi_kinerja ? Str::limit($instrumen->evidensi_kinerja, 100) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-primary">{{ $instrumen->skor_min }} - {{ $instrumen->skor_max }}</span>
                        </td>
                        <td>
                            @if($instrumen->bukti_url)
                                <a href="{{ $instrumen->bukti_url }}" target="_blank" class="btn btn-sm btn-outline-info">
                                    <i class="fas fa-external-link-alt"></i> Lihat
                                </a>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <div class="text-muted text-justify">
                                {{ $instrumen->catatan_verifikasi ? Str::limit($instrumen->catatan_verifikasi, 80) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-info btn-sm" title="Lihat Detail" 
                                        onclick="showDetail({{ $instrumen->id }})">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <a href="{{ route('admin.instrumen-penilaian.edit', $instrumen) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.instrumen-penilaian.destroy', $instrumen) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus" 
                                            onclick="return confirm('Apakah Anda yakin ingin menghapus instrumen ini?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">
                            <div class="py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada instrumen penilaian. <a href="{{ route('admin.instrumen-penilaian.create', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}">Tambah instrumen pertama</a></p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Detail -->
<div class="modal fade" id="detailModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Instrumen Penilaian</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body" id="detailContent">
                <!-- Content will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Instrumen Penilaian</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form action="{{ route('admin.instrumen-penilaian.import', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Petunjuk Import:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Download template Excel terlebih dahulu</li>
                            <li>Isi data sesuai template</li>
                            <li>Upload file .xlsx (maksimal 20MB)</li>
                            <li>Kolom bertanda (*) wajib diisi</li>
                        </ul>
                    </div>
                    
                    <div class="form-group">
                        <label for="file">File Excel (.xlsx)</label>
                        <input type="file" class="form-control @error('file') is-invalid @enderror" 
                               id="file" name="file" accept=".xlsx" required>
                        @error('file')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">Maksimal 20MB</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload"></i> Import Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function showDetail(id) {
    $('#detailContent').html('<p>Loading detail for instrumen ID: ' + id + '</p>');
    $('#detailModal').modal('show');
    $.get("{{ url('/admin/instrumen-penilaian') }}/" + id, function(html) {
        $('#detailContent').html(html);
    }).fail(function() {
        $('#detailContent').html('<div class="alert alert-danger">Gagal memuat detail instrumen.</div>');
    });
}
</script>
@endpush
