@extends('layouts.app')

@section('title', 'Edit Instrumen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen.show', $komponen->instrumen) }}">{{ $komponen->instrumen->judul }}</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.komponen-penilaian.index', $komponen->instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.sub-komponen.index', $komponen) }}">Sub Komponen</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.instrumen-penilaian.index', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}">Instrumen Penilaian</a></li>
<li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-edit"></i> Edit Instrumen Penilaian
        </h3>
    </div>
    <div class="card-body">
        <!-- Komponen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-cogs"></i> {{ $komponen->nama_komponen }}</h5>
            <p class="mb-0">{{ $komponen->deskripsi }}</p>
            <small>Instrumen: {{ $komponen->instrumen->judul }} - Urutan: {{ $komponen->urutan }}</small>
        </div>

        <!-- Sub Komponen Info -->
        <div class="alert alert-success">
            <h5><i class="fas fa-layer-group"></i> {{ $subKomponen->nama_sub_komponen }}</h5>
            <p class="mb-0">{{ $subKomponen->deskripsi }}</p>
            <small>Urutan: {{ $subKomponen->urutan }}</small>
        </div>

        <form action="{{ route('admin.instrumen-penilaian.update', $instrumenPenilaian) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <label for="no_urutan">No Urutan <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('no_urutan') is-invalid @enderror" 
                               id="no_urutan" name="no_urutan" value="{{ old('no_urutan', $instrumenPenilaian->no_urutan) }}" 
                               required min="1">
                        @error('no_urutan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="skor_min">Skor Minimum <span class="text-danger">*</span></label>
                        <select class="form-control @error('skor_min') is-invalid @enderror" id="skor_min" name="skor_min" required>
                            <option value="">Pilih Skor Min</option>
                            <option value="1" {{ old('skor_min', $instrumenPenilaian->skor_min) == '1' ? 'selected' : '' }}>1</option>
                            <option value="2" {{ old('skor_min', $instrumenPenilaian->skor_min) == '2' ? 'selected' : '' }}>2</option>
                            <option value="3" {{ old('skor_min', $instrumenPenilaian->skor_min) == '3' ? 'selected' : '' }}>3</option>
                            <option value="4" {{ old('skor_min', $instrumenPenilaian->skor_min) == '4' ? 'selected' : '' }}>4</option>
                        </select>
                        @error('skor_min')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="skor_max">Skor Maksimum <span class="text-danger">*</span></label>
                        <select class="form-control @error('skor_max') is-invalid @enderror" id="skor_max" name="skor_max" required>
                            <option value="">Pilih Skor Max</option>
                            <option value="1" {{ old('skor_max', $instrumenPenilaian->skor_max) == '1' ? 'selected' : '' }}>1</option>
                            <option value="2" {{ old('skor_max', $instrumenPenilaian->skor_max) == '2' ? 'selected' : '' }}>2</option>
                            <option value="3" {{ old('skor_max', $instrumenPenilaian->skor_max) == '3' ? 'selected' : '' }}>3</option>
                            <option value="4" {{ old('skor_max', $instrumenPenilaian->skor_max) == '4' ? 'selected' : '' }}>4</option>
                        </select>
                        @error('skor_max')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="is_active">Status</label>
                        <select class="form-control @error('is_active') is-invalid @enderror" id="is_active" name="is_active">
                            <option value="1" {{ old('is_active', $instrumenPenilaian->is_active) == '1' ? 'selected' : '' }}>Aktif</option>
                            <option value="0" {{ old('is_active', $instrumenPenilaian->is_active) == '0' ? 'selected' : '' }}>Nonaktif</option>
                        </select>
                        @error('is_active')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="indikator_kinerja">Indikator Kinerja <span class="text-danger">*</span></label>
                <textarea class="form-control @error('indikator_kinerja') is-invalid @enderror" 
                          id="indikator_kinerja" name="indikator_kinerja" rows="4" 
                          required placeholder="Masukkan indikator kinerja yang akan dinilai">{{ old('indikator_kinerja', $instrumenPenilaian->indikator_kinerja) }}</textarea>
                @error('indikator_kinerja')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="form-text text-muted">Deskripsikan indikator kinerja yang akan dinilai</small>
            </div>

            <div class="form-group">
                <label for="evidensi_kinerja">Evidensi Kinerja (Bukti Pendukung)</label>
                <textarea class="form-control @error('evidensi_kinerja') is-invalid @enderror" 
                          id="evidensi_kinerja" name="evidensi_kinerja" rows="3" 
                          placeholder="Masukkan bukti pendukung yang diperlukan">{{ old('evidensi_kinerja', $instrumenPenilaian->evidensi_kinerja) }}</textarea>
                @error('evidensi_kinerja')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="form-text text-muted">Jelaskan bukti pendukung yang diperlukan untuk menilai indikator ini</small>
            </div>

            <div class="form-group">
                <label for="bukti_url">Template Bukti URL</label>
                <input type="url" class="form-control @error('bukti_url') is-invalid @enderror" 
                       id="bukti_url" name="bukti_url" value="{{ old('bukti_url', $instrumenPenilaian->bukti_url) }}" 
                       placeholder="https://example.com/template-bukti">
                @error('bukti_url')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="form-text text-muted">
                    <i class="fas fa-info-circle text-info"></i> 
                    Template URL yang akan diisi oleh <strong>Guru</strong> sebagai bukti pendukung
                </small>
            </div>

            <div class="form-group">
                <label for="catatan_verifikasi">Template Catatan Verifikasi</label>
                <textarea class="form-control @error('catatan_verifikasi') is-invalid @enderror" 
                          id="catatan_verifikasi" name="catatan_verifikasi" rows="3" 
                          placeholder="Template catatan untuk kepala lembaga">{{ old('catatan_verifikasi', $instrumenPenilaian->catatan_verifikasi) }}</textarea>
                @error('catatan_verifikasi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="form-text text-muted">
                    <i class="fas fa-info-circle text-info"></i> 
                    Template catatan yang akan diisi oleh <strong>Kepala Lembaga</strong> untuk hasil verifikasi
                </small>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Instrumen
                </button>
                <a href="{{ route('admin.instrumen-penilaian.index', ['komponen' => $komponen, 'subKomponen' => $subKomponen]) }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-update skor_max options based on skor_min
    $('#skor_min').on('change', function() {
        var minValue = parseInt($(this).val());
        var maxSelect = $('#skor_max');
        
        maxSelect.find('option').each(function() {
            var optionValue = parseInt($(this).val());
            if (optionValue < minValue) {
                $(this).prop('disabled', true);
            } else {
                $(this).prop('disabled', false);
            }
        });
        
        // If current max value is less than new min value, reset it
        if (parseInt(maxSelect.val()) < minValue) {
            maxSelect.val(minValue);
        }
    });
    
    // Trigger change on page load
    $('#skor_min').trigger('change');
});
</script>
@endpush
