@extends('layouts.app')

@section('title', 'Dashboard Admin')

@section('breadcrumb')
<li class="breadcrumb-item active">Dashboard</li>
@endsection

@section('content')
<!-- Info boxes -->
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info elevation-1"><i class="fas fa-users"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Users</span>
                <span class="info-box-number">{{ \App\Models\User::count() }}</span>
                <div class="progress">
                    <div class="progress-bar bg-info" style="width: 70%"></div>
                </div>
                <span class="progress-description">
                    {{ \App\Models\User::where('is_active', true)->count() }} Aktif
                </span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-school"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Lembaga</span>
                <span class="info-box-number">{{ \App\Models\Lembaga::count() }}</span>
                <div class="progress">
                    <div class="progress-bar bg-danger" style="width: 60%"></div>
                </div>
                <span class="progress-description">
                    {{ \App\Models\Lembaga::where('akreditasi', '!=', null)->count() }} Terakreditasi
                </span>
            </div>
        </div>
    </div>
    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-clipboard-list"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Instrumen</span>
                <span class="info-box-number">{{ \App\Models\Instrumen::count() }}</span>
                <div class="progress">
                    <div class="progress-bar bg-success" style="width: 80%"></div>
                </div>
                <span class="progress-description">
                    {{ \App\Models\Instrumen::where('is_active', true)->count() }} Aktif
                </span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <!-- Removed: Total Guru box (role & model guru ditiadakan) -->
    </div>
</div>

<!-- Main row -->
<div class="row">
    <div class="col-md-8">
        <!-- Chart -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-bar mr-1"></i>
                    Statistik Distribusi Data
                </h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5><i class="fas fa-users text-info"></i> Per Role</h5>
                        <canvas id="roleChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                    <div class="col-md-6">
                        <h5><i class="fas fa-school text-danger"></i> Per Jenis Lembaga</h5>
                        <canvas id="lembagaChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-history mr-1"></i>
                    Aktivitas Sistem Terbaru
                </h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Waktu</th>
                                <th>Aktivitas</th>
                                <th>User</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>{{ date('H:i') }}</td>
                                <td>Login Admin</td>
                                <td>{{ auth()->user()->name }}</td>
                                <td><span class="badge badge-success">Berhasil</span></td>
                            </tr>
                            <tr>
                                <td>{{ date('H:i', strtotime('-5 minutes')) }}</td>
                                <td>Update Data Lembaga</td>
                                <td>System</td>
                                <td><span class="badge badge-info">Selesai</span></td>
                            </tr>
                            <tr>
                                <td>{{ date('H:i', strtotime('-10 minutes')) }}</td>
                                <td>Backup Database</td>
                                <td>System</td>
                                <td><span class="badge badge-success">Berhasil</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Quick Stats -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-tachometer-alt mr-1"></i>
                    Quick Stats
                </h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3>{{ \App\Models\User::whereDate('created_at', today())->count() }}</h3>
                                <p>User Baru Hari Ini</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-user-plus"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>{{ \App\Models\Lembaga::whereDate('created_at', today())->count() }}</h3>
                                <p>Lembaga Baru Hari Ini</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-school"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Info -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-info-circle mr-1"></i>
                    Informasi Sistem
                </h3>
            </div>
            <div class="card-body">
                <div class="info-box-content">
                    <div class="row mb-2">
                        <div class="col-6"><strong>Versi Laravel:</strong></div>
                        <div class="col-6">{{ app()->version() }}</div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-6"><strong>PHP Version:</strong></div>
                        <div class="col-6">{{ PHP_VERSION }}</div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-6"><strong>Database:</strong></div>
                        <div class="col-6">{{ config('database.default') }}</div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-6"><strong>Server Time:</strong></div>
                        <div class="col-6">{{ date('d/m/Y H:i:s') }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-bolt mr-1"></i>
                    Quick Actions
                </h3>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.users.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-user-plus"></i> Tambah User
                    </a>
                    <a href="{{ route('admin.lembaga.create') }}" class="btn btn-danger btn-sm">
                        <i class="fas fa-school"></i> Tambah Lembaga
                    </a>
                    <a href="{{ route('admin.instrumen.create') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-clipboard-list"></i> Tambah Instrumen
                    </a>
                    <a href="#" class="btn btn-info btn-sm">
                        <i class="fas fa-download"></i> Export Data
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Role Chart
const roleCtx = document.getElementById('roleChart').getContext('2d');
new Chart(roleCtx, {
    type: 'doughnut',
    data: {
        labels: ['Admin', 'Pengawas', 'Kepala'],
        datasets: [{
            data: [
                {{ \App\Models\User::role('admin')->count() }},
                {{ \App\Models\User::role('pengawas')->count() }},
                {{ \App\Models\User::role('kepala')->count() }}
            ],
            backgroundColor: ['#dc3545', '#17a2b8', '#28a745']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

// Lembaga Chart
const lembagaCtx = document.getElementById('lembagaChart').getContext('2d');
new Chart(lembagaCtx, {
    type: 'pie',
    data: {
        labels: ['RA', 'MI', 'MTs', 'MA'],
        datasets: [{
            data: [
                {{ \App\Models\Lembaga::where('jenis', 'RA')->count() }},
                {{ \App\Models\Lembaga::where('jenis', 'MI')->count() }},
                {{ \App\Models\Lembaga::where('jenis', 'MTs')->count() }},
                {{ \App\Models\Lembaga::where('jenis', 'MA')->count() }}
            ],
            backgroundColor: ['#007bff', '#28a745', '#17a2b8', '#ffc107']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});
</script>
@endpush
@endsection