<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create roles
        $roles = [
            'admin' => 'Administrator',
            'pengawas' => 'Pengawas Sekolah/Madrasah',
            'kepala' => 'Kepala Sekolah/Madrasah'
        ];

        foreach ($roles as $name => $displayName) {
            \Spatie\Permission\Models\Role::create([
                'name' => $name,
                'guard_name' => 'web'
            ]);
        }

        // Create permissions
        $permissions = [
            // Admin permissions
            'manage-users',
            'manage-lembaga',
            'manage-instrumen',
            'view-all-data',
            
            // Pengawas permissions
            'create-lembaga',
            'edit-lembaga',
            'delete-lembaga',
            'create-instrumen',
            'edit-instrumen',
            'delete-instrumen',
            'distribute-instrumen',
            'penilaian-kepala:create',
            'penilaian-kepala:update',
            'penilaian-kepala:submit',
            'penilaian-kepala:view',
            
            // Kepala permissions
            'review-instrumen',
            'penilaian-kepala:view-own',
            'raport:view-own',
        ];

        foreach ($permissions as $permission) {
            \Spatie\Permission\Models\Permission::create([
                'name' => $permission,
                'guard_name' => 'web'
            ]);
        }

        // Assign permissions to roles
        $adminRole = \Spatie\Permission\Models\Role::findByName('admin');
        $adminRole->givePermissionTo([
            'manage-users', 'manage-lembaga', 'manage-instrumen', 'view-all-data'
        ]);

        $pengawasRole = \Spatie\Permission\Models\Role::findByName('pengawas');
        $pengawasRole->givePermissionTo([
            'create-lembaga', 'edit-lembaga', 'delete-lembaga',
            'create-instrumen', 'edit-instrumen', 'delete-instrumen',
            'distribute-instrumen',
            'penilaian-kepala:create', 'penilaian-kepala:update', 'penilaian-kepala:submit', 'penilaian-kepala:view'
        ]);

        $kepalaRole = \Spatie\Permission\Models\Role::findByName('kepala');
        $kepalaRole->givePermissionTo([
            'review-instrumen', 'penilaian-kepala:view-own', 'raport:view-own'
        ]);
    }
}
