<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Pengawas;
use Illuminate\Support\Facades\Hash;

class PengawasSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create pengawas users if they don't have pengawas profile
        $pengawasUsers = User::whereHas('roles', function($query) {
            $query->where('name', 'pengawas');
        })->get();

        foreach ($pengawasUsers as $user) {
            if (!$user->pengawas) {
                Pengawas::create([
                    'user_id' => $user->id,
                    'nip' => 'P' . str_pad($user->id, 8, '0', STR_PAD_LEFT),
                    'nuptk' => 'NUPTK' . str_pad($user->id, 10, '0', STR_PAD_LEFT),
                    'nama_lengkap' => $user->name,
                    'gelar_depan' => 'Dr.',
                    'gelar_belakang' => 'M.Pd',
                    'tempat_lahir' => 'Jakarta',
                    'tanggal_lahir' => '1980-01-01',
                    'jenis_kelamin' => 'L',
                    'pendidikan_terakhir' => 'S3',
                    'jurusan' => 'Pendidikan',
                    'alamat' => 'Jl. Pendidikan No. 1, Jakarta',
                    'telepon' => '081234567890',
                ]);
            }
        }
    }
}