<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Kepala;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class KepalaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Find or create Kepala role
        $kepalaRole = Role::firstOrCreate(['name' => 'kepala']);

        // Create a default kepala user if not exists
        $kepalaUser = User::firstOrCreate(
            ['email' => 'kepala@penilaian.com'],
            [
                'name' => 'Dr. Siti Kepala, M.Pd',
                'password' => Hash::make('password'), // Default password for testing
                'phone' => '081234567890',
                'is_active' => true,
            ]
        );
        $kepalaUser->assignRole($kepalaRole);

        // Create kepala profile if not exists
        Kepala::firstOrCreate(
            ['user_id' => $kepalaUser->id],
            [
                'nip' => 'K00000001',
                'nuptk' => 'NUPTK0000000001',
                'nama_lengkap' => 'Siti Kepala',
                'gelar_depan' => 'Dr.',
                'gelar_belakang' => 'M.Pd',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1975-05-20',
                'jenis_kelamin' => 'P',
                'pendidikan_terakhir' => 'S2',
                'jurusan' => 'Manajemen Pendidikan',
                'alamat' => 'Jl. Kepala Sekolah No. 1, Jakarta',
                'telepon' => '081234567890',
            ]
        );

        // Create another kepala user for testing
        $kepalaUser2 = User::firstOrCreate(
            ['email' => 'kepala2@penilaian.com'],
            [
                'name' => 'Budi Kepala, S.Pd',
                'password' => Hash::make('password'), // Default password for testing
                'phone' => '081234567891',
                'is_active' => true,
            ]
        );
        $kepalaUser2->assignRole($kepalaRole);

        Kepala::firstOrCreate(
            ['user_id' => $kepalaUser2->id],
            [
                'nip' => 'K00000002',
                'nuptk' => 'NUPTK0000000002',
                'nama_lengkap' => 'Budi Kepala, S.Pd',
                'gelar_depan' => null,
                'gelar_belakang' => 'S.Pd',
                'tempat_lahir' => 'Bandung',
                'tanggal_lahir' => '1980-08-15',
                'jenis_kelamin' => 'L',
                'pendidikan_terakhir' => 'S1',
                'jurusan' => 'Pendidikan Matematika',
                'alamat' => 'Jl. Pendidikan No. 10, Bandung',
                'telepon' => '081234567891',
            ]
        );
    }
}