<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DummyDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Admin User
        $admin = \App\Models\User::create([
            'name' => 'Administrator',
            'email' => 'admin@penilaian.com',
            'password' => bcrypt('password'),
            'phone' => '081234567890',
            'is_active' => true,
        ]);
        $admin->assignRole('admin');

        // Create Pengawas User
        $pengawas = \App\Models\User::create([
            'name' => 'Dr. Ahmad Pengawas, M.Pd',
            'email' => 'pengawas@penilaian.com',
            'password' => bcrypt('password'),
            'phone' => '081234567891',
            'is_active' => true,
        ]);
        $pengawas->assignRole('pengawas');

        // Create Lembaga
        $lembaga = \App\Models\Lembaga::create([
            'pengawas_id' => $pengawas->id,
            'npsn_nsm' => '12345678',
            'nama_lembaga' => 'MI Negeri 1 Contoh',
            'jenis' => 'MI',
            'alamat_lengkap' => 'Jl. Pendidikan No. 123',
            'kelurahan' => 'Pendidikan',
            'kecamatan' => 'Pendidikan',
            'kabupaten' => 'Kota Pendidikan',
            'provinsi' => 'Jawa Tengah',
            'kode_pos' => '12345',
            'telepon' => '0271-123456',
            'email' => 'min1contoh@email.com',
            'nama_kepala' => 'Siti Kepala, S.Pd',
            'nip_kepala' => '196512121990032001',
            'akreditasi' => 'A',
            'tahun_berdiri' => 1990,
        ]);

        // Create Kepala User
        $kepala = \App\Models\User::create([
            'name' => 'Siti Kepala, S.Pd',
            'email' => 'kepala@penilaian.com',
            'password' => bcrypt('password'),
            'phone' => '081234567892',
            'is_active' => true,
        ]);
        $kepala->assignRole('kepala');

        // Create Guru Users and Data
        $guru1 = \App\Models\User::create([
            'name' => 'Budi Guru, S.Pd',
            'email' => 'guru1@penilaian.com',
            'password' => bcrypt('password'),
            'phone' => '081234567893',
            'is_active' => true,
        ]);
        $guru1->assignRole('guru');

        \App\Models\Guru::create([
            'user_id' => $guru1->id,
            'lembaga_id' => $lembaga->id,
            'nip' => '198012121990032002',
            'nuptk' => '1234567890123456',
            'nama_lengkap' => 'Budi Guru',
            'gelar_depan' => null,
            'gelar_belakang' => 'S.Pd',
            'tempat_lahir' => 'Jakarta',
            'tanggal_lahir' => '1980-12-12',
            'jenis_kelamin' => 'L',
            'pendidikan_terakhir' => 'S1',
            'jurusan' => 'Pendidikan Matematika',
            'mata_pelajaran' => 'Matematika',
            'kelas_diampu' => 'IV, V, VI',
            'status_kepegawaian' => 'PNS',
            'status_sertifikasi' => 'sudah',
            'tahun_sertifikasi' => 2015,
            'no_sertifikat' => '1234567890',
            'status_inpassing' => 'sudah',
            'golongan' => 'III/a',
            'tmt_golongan' => '2010-01-01',
            'alamat' => 'Jl. Guru No. 123, Jakarta',
            'telepon' => '081234567893',
        ]);

        $guru2 = \App\Models\User::create([
            'name' => 'Siti Guru, S.Pd',
            'email' => 'guru2@penilaian.com',
            'password' => bcrypt('password'),
            'phone' => '081234567894',
            'is_active' => true,
        ]);
        $guru2->assignRole('guru');

        \App\Models\Guru::create([
            'user_id' => $guru2->id,
            'lembaga_id' => $lembaga->id,
            'nip' => '198512121990032003',
            'nuptk' => '1234567890123457',
            'nama_lengkap' => 'Siti Guru',
            'gelar_depan' => null,
            'gelar_belakang' => 'S.Pd',
            'tempat_lahir' => 'Bandung',
            'tanggal_lahir' => '1985-12-12',
            'jenis_kelamin' => 'P',
            'pendidikan_terakhir' => 'S1',
            'jurusan' => 'Pendidikan Bahasa Indonesia',
            'mata_pelajaran' => 'Bahasa Indonesia',
            'kelas_diampu' => 'I, II, III',
            'status_kepegawaian' => 'PNS',
            'status_sertifikasi' => 'sudah',
            'tahun_sertifikasi' => 2016,
            'no_sertifikat' => '1234567891',
            'status_inpassing' => 'sudah',
            'golongan' => 'III/b',
            'tmt_golongan' => '2012-01-01',
            'alamat' => 'Jl. Guru No. 456, Bandung',
            'telepon' => '081234567894',
        ]);

        // Create Instrumen
        $instrumen = \App\Models\Instrumen::create([
            'pengawas_id' => $pengawas->id,
            'judul' => 'Instrumen Penilaian Kinerja Guru Tahun 2024',
            'deskripsi' => 'Instrumen penilaian kinerja guru untuk semester ganjil tahun pelajaran 2024/2025',
            'tahun_ajaran' => '2024/2025',
            'semester' => '1',
            'is_active' => true,
        ]);

        // Create Instrumen Items
        $items = [
            [
                'nomor_urut' => 1,
                'aspek_dimensi' => 'Kompetensi Pedagogik',
                'indikator' => 'Guru mampu menguasai karakteristik peserta didik dari aspek fisik, moral, spiritual, sosial, kultural, emosional, dan intelektual',
                'sub_indikator' => 'Mengidentifikasi karakteristik peserta didik yang berkaitan dengan aspek fisik, intelektual, sosial-emosional, moral, spiritual, dan latar belakang sosial-budaya',
                'bukti_yang_diperlukan' => 'RPP yang mencantumkan karakteristik peserta didik, dokumen analisis karakteristik peserta didik, foto kegiatan pembelajaran yang menunjukkan perhatian terhadap karakteristik peserta didik',
                'bobot' => 1.00,
            ],
            [
                'nomor_urut' => 2,
                'aspek_dimensi' => 'Kompetensi Pedagogik',
                'indikator' => 'Guru mampu menguasai teori belajar dan prinsip-prinsip pembelajaran yang mendidik',
                'sub_indikator' => 'Menerapkan berbagai pendekatan, strategi, metode, dan teknik pembelajaran yang mendidik secara kreatif dalam mata pelajaran yang diampu',
                'bukti_yang_diperlukan' => 'RPP dengan pendekatan pembelajaran yang bervariasi, dokumen refleksi pembelajaran, video pembelajaran yang menunjukkan variasi metode',
                'bobot' => 1.00,
            ],
            [
                'nomor_urut' => 3,
                'aspek_dimensi' => 'Kompetensi Pedagogik',
                'indikator' => 'Guru mampu mengembangkan kurikulum yang terkait dengan mata pelajaran yang diampu',
                'sub_indikator' => 'Menyusun silabus sesuai dengan tujuan terpenting kurikulum dan menggunakan RPP sesuai dengan tujuan dan lingkungan pembelajaran',
                'bukti_yang_diperlukan' => 'Silabus mata pelajaran, RPP yang sesuai dengan kurikulum, dokumen analisis KI-KD',
                'bobot' => 1.00,
            ],
            [
                'nomor_urut' => 4,
                'aspek_dimensi' => 'Kompetensi Kepribadian',
                'indikator' => 'Bertindak sesuai dengan norma agama, hukum, sosial, dan kebudayaan nasional Indonesia',
                'sub_indikator' => 'Menampilkan diri sebagai pribadi yang jujur, berakhlak mulia, dan teladan bagi peserta didik dan masyarakat',
                'bukti_yang_diperlukan' => 'Surat keterangan berkelakuan baik, dokumen keagamaan, foto kegiatan sosial',
                'bobot' => 1.00,
            ],
            [
                'nomor_urut' => 5,
                'aspek_dimensi' => 'Kompetensi Sosial',
                'indikator' => 'Berkomunikasi secara efektif, empatik, dan santun dengan sesama pendidik, tenaga kependidikan, orang tua, dan masyarakat',
                'sub_indikator' => 'Berkomunikasi dengan teman sejawat secara santun dan empatik',
                'bukti_yang_diperlukan' => 'Dokumen komunikasi dengan rekan kerja, foto kegiatan rapat, undangan kegiatan sekolah',
                'bobot' => 1.00,
            ],
        ];

        foreach ($items as $item) {
            \App\Models\InstrumenItem::create(array_merge($item, [
                'instrumen_id' => $instrumen->id,
            ]));
        }

        // Create Distribusi Instrumen
        \App\Models\DistribusiInstrumen::create([
            'instrumen_id' => $instrumen->id,
            'lembaga_id' => $lembaga->id,
            'tanggal_distribusi' => now()->format('Y-m-d'),
            'deadline' => now()->addDays(30)->format('Y-m-d'),
            'status' => 'active',
        ]);
    }
}
