<?php

namespace Database\Seeders;

use App\Models\AppSettings;
use Illuminate\Database\Seeder;

class AppSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        AppSettings::create([
            'app_name' => 'Sistem Penilaian Kinerja Guru',
            'app_description' => 'Sistem manajemen penilaian kinerja guru berbasis web untuk lembaga pendidikan Islam',
            'app_version' => '1.0.0',
            'app_author' => 'Tim Development',
            'app_email' => 'admin@penilaian.com',
            'app_phone' => '081234567890',
            'app_address' => 'Jl. Pendidikan No. 123, Jakarta Pusat, DKI Jakarta',
            'app_website' => 'https://penilaian.com',
            'app_timezone' => 'Asia/Jakarta',
            'app_locale' => 'id',
            'app_pagination' => 10,
            'app_maintenance' => false,
            'maintenance_message' => 'Sistem sedang dalam maintenance. Mohon maaf atas ketidaknyamanan ini.',
            'app_notifications' => true,
            'app_logs' => true,
            'backup_frequency' => 'daily',
            'backup_retention' => 30,
        ]);
    }
}