<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('jawaban_kepala')) {
            // Drop old FK by raw SQL to avoid name differences
            try { DB::statement('ALTER TABLE jawaban_kepala DROP FOREIGN KEY jawaban_kepala_instrumen_item_id_foreign'); } catch (\Throwable $e) {}
            try { DB::statement('ALTER TABLE jawaban_kepala DROP FOREIGN KEY jawaban_guru_instrumen_item_id_foreign'); } catch (\Throwable $e) {}

            Schema::table('jawaban_kepala', function (Blueprint $table) {
                if (!Schema::hasColumn('jawaban_kepala', 'instrumen_item_id')) {
                    $table->unsignedBigInteger('instrumen_item_id')->after('penilaian_kepala_id');
                }
                try {
                    $table->foreign('instrumen_item_id')->references('id')
                        ->on('instrumen_penilaians')->onDelete('cascade');
                } catch (\Throwable $e) {}
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('jawaban_kepala')) {
            Schema::table('jawaban_kepala', function (Blueprint $table) {
                try { $table->dropForeign(['instrumen_item_id']); } catch (\Throwable $e) {}
            });
        }
    }
};


