<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('penilaian_kepala')) {
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                // Drop legacy FK that still references `guru` table after rename
                try {
                    $table->dropForeign('penilaian_guru_guru_id_foreign');
                } catch (\Throwable $e) {
                    // ignore if not exists
                }

                // Ensure foreign keys reference the correct tables
                if (Schema::hasColumn('penilaian_kepala', 'kepala_id')) {
                    try {
                        $table->foreign('kepala_id')->references('id')->on('users')->onDelete('cascade');
                    } catch (\Throwable $e) {}
                }
                if (Schema::hasColumn('penilaian_kepala', 'pengawas_id')) {
                    try {
                        $table->foreign('pengawas_id')->references('id')->on('users')->onDelete('cascade');
                    } catch (\Throwable $e) {}
                }
                if (Schema::hasColumn('penilaian_kepala', 'distribusi_instrumen_id')) {
                    try {
                        $table->foreign('distribusi_instrumen_id')->references('id')->on('distribusi_instrumen')->onDelete('cascade');
                    } catch (\Throwable $e) {}
                }
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('penilaian_kepala')) {
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                try { $table->dropForeign(['kepala_id']); } catch (\Throwable $e) {}
                try { $table->dropForeign(['pengawas_id']); } catch (\Throwable $e) {}
                try { $table->dropForeign(['distribusi_instrumen_id']); } catch (\Throwable $e) {}
            });
        }
    }
};


