<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('distribusi_instrumen')) {
            Schema::table('distribusi_instrumen', function (Blueprint $table) {
                if (!Schema::hasColumn('distribusi_instrumen', 'komponen_id')) {
                    $table->unsignedBigInteger('komponen_id')->nullable()->after('instrumen_id');
                }
                if (!Schema::hasColumn('distribusi_instrumen', 'jenis_distribusi')) {
                    $table->enum('jenis_distribusi', ['semua_komponen', 'per_komponen'])->default('semua_komponen')->after('status');
                }
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('distribusi_instrumen')) {
            Schema::table('distribusi_instrumen', function (Blueprint $table) {
                if (Schema::hasColumn('distribusi_instrumen', 'jenis_distribusi')) {
                    $table->dropColumn('jenis_distribusi');
                }
                if (Schema::hasColumn('distribusi_instrumen', 'komponen_id')) {
                    $table->dropColumn('komponen_id');
                }
            });
        }
    }
};


