<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('validasi_pengawas')) {
            Schema::table('validasi_pengawas', function (Blueprint $table) {
                if (Schema::hasColumn('validasi_pengawas', 'penilaian_guru_id') && !Schema::hasColumn('validasi_pengawas', 'penilaian_kepala_id')) {
                    $table->renameColumn('penilaian_guru_id', 'penilaian_kepala_id');
                }
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('validasi_pengawas')) {
            Schema::table('validasi_pengawas', function (Blueprint $table) {
                if (Schema::hasColumn('validasi_pengawas', 'penilaian_kepala_id')) {
                    $table->renameColumn('penilaian_kepala_id', 'penilaian_guru_id');
                }
            });
        }
    }
};


