<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Rename tables
        if (Schema::hasTable('penilaian_guru')) {
            Schema::rename('penilaian_guru', 'penilaian_kepala');
        }

        if (Schema::hasTable('jawaban_guru')) {
            Schema::rename('jawaban_guru', 'jawaban_kepala');
        }

        // Rename columns on penilaian_kepala
        if (Schema::hasTable('penilaian_kepala')) {
            // Step 1: rename existing evaluator column `kepala_id` to `pengawas_id`
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                if (Schema::hasColumn('penilaian_kepala', 'kepala_id')) {
                    $table->renameColumn('kepala_id', 'pengawas_id');
                }
            });

            // Step 2: rename subject column `guru_id` to new `kepala_id`
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                if (Schema::hasColumn('penilaian_kepala', 'guru_id')) {
                    $table->renameColumn('guru_id', 'kepala_id');
                }
            });

            // Step 3: rename notes column
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                if (Schema::hasColumn('penilaian_kepala', 'catatan_kepala')) {
                    $table->renameColumn('catatan_kepala', 'catatan_pengawas');
                }
            });

            // Step 4: ensure pengawas_id exists (for older schemas)
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                if (!Schema::hasColumn('penilaian_kepala', 'pengawas_id')) {
                    $table->unsignedBigInteger('pengawas_id')->after('kepala_id');
                }
            });
        }

        // Rename columns on jawaban_kepala
        if (Schema::hasTable('jawaban_kepala')) {
            Schema::table('jawaban_kepala', function (Blueprint $table) {
                if (Schema::hasColumn('jawaban_kepala', 'penilaian_guru_id')) {
                    $table->renameColumn('penilaian_guru_id', 'penilaian_kepala_id');
                }
                if (Schema::hasColumn('jawaban_kepala', 'nilai_kepala')) {
                    $table->renameColumn('nilai_kepala', 'nilai_pengawas');
                }
                if (Schema::hasColumn('jawaban_kepala', 'catatan_kepala')) {
                    $table->renameColumn('catatan_kepala', 'catatan_pengawas');
                }
            });
        }

        // (Optional) Add foreign keys if missing — skip if DB already has them
        // Note: Laravel cannot easily check existing FK names; keep minimal to avoid duplication errors.
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert column renames on jawaban_kepala
        if (Schema::hasTable('jawaban_kepala')) {
            Schema::table('jawaban_kepala', function (Blueprint $table) {
                if (Schema::hasColumn('jawaban_kepala', 'penilaian_kepala_id')) {
                    $table->renameColumn('penilaian_kepala_id', 'penilaian_guru_id');
                }
                if (Schema::hasColumn('jawaban_kepala', 'nilai_pengawas')) {
                    $table->renameColumn('nilai_pengawas', 'nilai_kepala');
                }
                if (Schema::hasColumn('jawaban_kepala', 'catatan_pengawas')) {
                    $table->renameColumn('catatan_pengawas', 'catatan_kepala');
                }
            });
        }

        // Revert column renames on penilaian_kepala
        if (Schema::hasTable('penilaian_kepala')) {
            Schema::table('penilaian_kepala', function (Blueprint $table) {
                if (Schema::hasColumn('penilaian_kepala', 'catatan_pengawas')) {
                    $table->renameColumn('catatan_pengawas', 'catatan_kepala');
                }
                if (Schema::hasColumn('penilaian_kepala', 'kepala_id')) {
                    $table->renameColumn('kepala_id', 'guru_id');
                }
                if (Schema::hasColumn('penilaian_kepala', 'pengawas_id')) {
                    $table->dropColumn('pengawas_id');
                }
            });
        }

        // Rename tables back
        if (Schema::hasTable('jawaban_kepala')) {
            Schema::rename('jawaban_kepala', 'jawaban_guru');
        }
        if (Schema::hasTable('penilaian_kepala')) {
            Schema::rename('penilaian_kepala', 'penilaian_guru');
        }
    }
};


