<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_settings', function (Blueprint $table) {
            $table->string('gemini_api_key')->nullable()->after('backup_retention');
            $table->string('gemini_model')->default('gemini-pro')->after('gemini_api_key');
            $table->boolean('gemini_enabled')->default(false)->after('gemini_model');
            $table->integer('gemini_max_tokens')->default(2048)->after('gemini_enabled');
            $table->decimal('gemini_temperature', 3, 2)->default(0.70)->after('gemini_max_tokens');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_settings', function (Blueprint $table) {
            $table->dropColumn([
                'gemini_api_key',
                'gemini_model', 
                'gemini_enabled',
                'gemini_max_tokens',
                'gemini_temperature'
            ]);
        });
    }
};
