<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // 'instrumen_submitted', 'instrumen_reviewed', etc.
            $table->string('title');
            $table->text('message');
            $table->unsignedBigInteger('user_id'); // Kepala sekolah yang menerima notifikasi
            $table->unsignedBigInteger('related_id')->nullable(); // ID terkait (penilaian_guru_id, etc.)
            $table->string('related_type')->nullable(); // Model terkait (PenilaianGuru, etc.)
            $table->boolean('is_read')->default(false);
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->index(['user_id', 'is_read']);
            $table->index(['type', 'related_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
