<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('instrumen_penilaians', function (Blueprint $table) {
            $table->foreignId('sub_komponen_id')->nullable()->constrained('sub_komponens')->onDelete('cascade')->after('komponen_penilaian_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('instrumen_penilaians', function (Blueprint $table) {
            $table->dropForeign(['sub_komponen_id']);
            $table->dropColumn('sub_komponen_id');
        });
    }
};
