<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('lembaga', function (Blueprint $table) {
            $table->string('kelurahan')->nullable()->change();
            $table->string('kecamatan')->nullable()->change();
            $table->string('kabupaten')->nullable()->change();
            $table->string('provinsi')->nullable()->change();
            $table->string('nama_kepala')->nullable()->change();
            $table->string('nip_kepala')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('lembaga', function (Blueprint $table) {
            $table->string('kelurahan')->nullable(false)->change();
            $table->string('kecamatan')->nullable(false)->change();
            $table->string('kabupaten')->nullable(false)->change();
            $table->string('provinsi')->nullable(false)->change();
            $table->string('nama_kepala')->nullable(false)->change();
            $table->string('nip_kepala')->nullable(false)->change();
        });
    }
};