<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('instrumen_penilaians', function (Blueprint $table) {
            $table->id();
            $table->foreignId('komponen_penilaian_id')->constrained('komponen_penilaians')->onDelete('cascade');
            $table->integer('no_urutan');
            $table->text('indikator_kinerja'); // Berisi instrumen penilaian
            $table->text('evidensi_kinerja')->nullable(); // Bukti pendukung
            $table->integer('skor_min')->default(1);
            $table->integer('skor_max')->default(4);
            $table->string('bukti_url')->nullable(); // URL untuk bukti
            $table->text('catatan_verifikasi')->nullable(); // Catatan/hasil verifikasi penilai
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('instrumen_penilaians');
    }
};
