<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_settings', function (Blueprint $table) {
            $table->id();
            $table->string('app_name')->default('Sistem Penilaian Kinerja Guru');
            $table->string('app_logo')->nullable();
            $table->string('app_favicon')->nullable();
            $table->text('app_description')->nullable();
            $table->string('app_version')->default('1.0.0');
            $table->string('app_author')->nullable();
            $table->string('app_email')->nullable();
            $table->string('app_phone')->nullable();
            $table->text('app_address')->nullable();
            $table->string('app_website')->nullable();
            $table->string('app_timezone')->default('Asia/Jakarta');
            $table->string('app_locale')->default('id');
            $table->string('app_currency')->default('IDR');
            $table->integer('app_pagination')->default(10);
            $table->boolean('app_maintenance')->default(false);
            $table->text('maintenance_message')->nullable();
            $table->boolean('app_notifications')->default(true);
            $table->boolean('app_logs')->default(true);
            $table->string('backup_frequency')->default('daily'); // daily, weekly, monthly
            $table->integer('backup_retention')->default(30); // days
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_settings');
    }
};