<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('validasi_pengawas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('penilaian_guru_id')->constrained('penilaian_guru')->onDelete('cascade');
            $table->foreignId('pengawas_id')->constrained('users')->onDelete('cascade');
            $table->enum('status', ['approved', 'revision'])->default('revision');
            $table->text('feedback')->nullable();
            $table->timestamp('tanggal_validasi')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('validasi_pengawas');
    }
};
