<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jawaban_guru', function (Blueprint $table) {
            $table->id();
            $table->foreignId('penilaian_guru_id')->constrained('penilaian_guru')->onDelete('cascade');
            $table->foreignId('instrumen_item_id')->constrained('instrumen_items')->onDelete('cascade');
            $table->string('url_bukti')->nullable();
            $table->text('keterangan_bukti')->nullable();
            $table->integer('nilai_guru_self')->nullable()->comment('Skala 1-5, opsional jika guru self-assessment');
            $table->integer('nilai_kepala')->nullable()->comment('Skala 1-5, dari review kepala');
            $table->text('catatan_kepala')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jawaban_guru');
    }
};
